#include "IncomingConnect.h"

#include "Gnutella.h"
#include "QtellaSub.h"
#include "Connections.h"
#include "UploadManager.h"
#include "DownloadManager.h"

#include "qsocket.h"
#include "qtimer.h"

IncomingConnect::IncomingConnect(Q_UINT16 port, int backlog = 0, QtellaSub *parent = 0) 
  : QServerSocket(port, backlog, parent, 0), _parent(parent), _socket(NULL)
{
  _timeout = new QTimer(this);
  connect(_timeout, SIGNAL(timeout()), SLOT(slotTimeout()));
}


void IncomingConnect::newConnection(int socket)
{
  if(_socket) return;

  _rec.erase();
  _socket = new QSocket();
  _socket->setSocket(socket);

  connect(_socket, SIGNAL(readyRead()), SLOT(slotReadyRead()));
  _timeout->start(3000);
}


void IncomingConnect::slotReadyRead()
{
  int     r = 0;
  char    buffer[1024];

  r = _socket->readBlock(buffer, 1024);
  _rec.append(buffer, r);

  // incoming connection
  if(_rec.find(CONNECT_STR) != std::string::npos)
    {
      _timeout->stop();
      std::string ip(_socket->peerAddress().toString());
      disconnect(_socket, 0, 0, 0);
      _parent->connections->addServant(Address(ip, _socket->port()), _socket);
      _socket = NULL;
      return;
    }

  // GET
  if( _rec.find("\r\n\r\n") != std::string::npos )
    {
      _timeout->stop();
      disconnect(_socket, 0, 0, 0);
      
      if(_rec.substr(0, 3) == "GET")
	{
	  _parent->upload_manager->addUpload(_rec, _socket);
	  _socket = NULL;
	  return;
	}
    }

  if( _rec.find("\n\n") != std::string::npos )
    {
      _timeout->stop();
      disconnect(_socket, 0, 0, 0);

      if(_rec.substr(0, 3) == "GIV")
	{
	  _parent->download_manager->updatePush(_rec, _socket);
	  _socket = NULL;
	  return;
	}
    }
}


void IncomingConnect::slotTimeout()
{
  if(_socket)
    {
      delete _socket;
      _socket = NULL;
    }

  _timeout->stop();
}


IncomingConnect::~IncomingConnect()
{
  if(_socket) delete _socket;
  if(_timeout) delete _timeout;
}
