#include "../include/MP3property.h"

#include <strstream>
#include <iostream>
#include <qfile.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include "StringManipulation.h"

/* 
 *  Constructs a MP3property which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
MP3property::MP3property( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : MP3FileProperties( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
MP3property::~MP3property()
{
    // no need to delete child widgets, Qt does it all for us
}


void MP3property::setFile(std::string directory, std::string filename)
{
  _directory.assign(directory);
  _filename.assign(filename);

  std::string c(directory + "/" + filename);

  ui_textlabel_directory->setText(directory.c_str());
  ui_textlabel_filename->setText(filename.c_str());
  
  QFile f(c.c_str());
  std::strstream str;
  str << f.size() << std::ends;
  ui_textlabel_size->setText( StringManipulation::insertDelimiter(std::string(str.str()), ',', 3).c_str() );
  str.freeze(false);

  ui_textlabel_type->setText("Music");

  
  if( f.open(IO_Raw | IO_ReadOnly) )
    {
      char buffer[128];
      int rd = f.readBlock(buffer, 10);
      f.close();

      if(rd!=10) return;
      
      std::string s(buffer, 10);

      if( s.substr(0, 3) == std::string("ID3") )
	{
	  std::cout << "ID3" << std::endl;

	  unsigned char  major_version = s[3];
	  unsigned char  minor_version = s[4];
	  bool           ext_header = ((s[5] & 64) > 0);
	  unsigned       tag_size = 0;

	  for(int i = 0; i < 4; ++i) tag_size = (tag_size << 7) | (s[i+6]);

	  if(major_version == 3)
	    {
	      std::cout << "version 3" << std::endl << "ext: " << ext_header << std::endl
			<< "tag size: " << tag_size << std::endl;
	    }
	  
// 	  ui_lineedit_title->setText(s.substr(3, 30).c_str());
// 	  ui_lineedit_artist->setText(s.substr(33, 30).c_str());
// 	  ui_lineedit_album->setText(s.substr(63, 30).c_str());
// 	  ui_lineedit_year->setText(s.substr(93, 4).c_str());
// 	  ui_lineedit_comment->setText(s.substr(97, 30).c_str());

// 	  unsigned char track = s[126];
// 	  ui_spinbox_track->setValue(track);

// 	  unsigned char genre = s[127];
// 	  if(genre > 80) genre = 80;
// 	  ui_combobox_genre->setCurrentItem(genre);
	}
    }
}
