#include "Message.h"
#include "Gnutella.h"

#include "Ping.h"
#include "Pong.h"
#include "Query.h"
#include "QueryHit.h"
#include "Push.h"

Message::Message(std::string& data, const uint32_t size)
  : _data(data)
{
  _id = _data.substr(0, 16);
  _ttl = static_cast<uint8_t>((unsigned char)_data[17]);
  _hops = static_cast<uint8_t>((unsigned char)_data[18]);
  _cmd = static_cast<uint8_t>((unsigned char)_data[16]);
  _payload = size-23;
  _payload_data = data.substr(23, size-23);
}

Message::Message()
{
}

Message::~Message()
{
}

const uint8_t Message::cmd()
{
  return _cmd;
}

std::string Message::id()
{
  return _id;
}

const uint8_t Message::ttl() 
{
  return _ttl;
}

const uint8_t Message::hops()
{
  return _hops;
}

const uint32_t Message::payload()
{
  return _payload;
}

void Message::inc_hops()
{
  ++_hops;
  _data[18] = _hops;
}

void Message::dec_ttl()
{
  --_ttl;
  _data[17] = _ttl;
}

std::string Message::data()
{
  return _data;
}

const uint32_t Message::size()
{
  return _payload;
}

Ping* Message::getPing()
{
  Ping* p = new Ping(_ttl, _hops, _id);
  return p;
}

Pong* Message::getPong()
{
  Pong* p = new Pong(_ttl, _hops, _id, _payload_data);
  return p;
}

Query* Message::getQuery()
{
  Query* q = new Query(_ttl, _hops, _id, _payload_data);
  return q;
}

QueryHit* Message::getQueryHit()
{
  QueryHit* q = new QueryHit(_ttl, _hops, _id, _payload_data);
  return q;
}

Push* Message::getPush()
{
  Push* p = new Push(_ttl, _hops, _id, _payload_data);
  return p;
}


std::string Message::uint_str(uint8_t value)
{
  std::string s;
  s.append((char*)&value, 1);
  return s;
}

std::string Message::uint_str(uint16_t value)
{
  std::string s;
  s.append((char*)&value, 2);
  return s;
}

std::string Message::uint_str(uint32_t value)
{
  std::string s;
  s.append((char*)&value, 4);
  return s;
}


bool Message::isValid()
{
  switch(cmd())
    {
    case CMD_PING: if(_data.size() >= PING_SIZE) return true; else return false;
    case CMD_PONG: if(_data.size() >= PONG_SIZE) return true; else return false;
    case CMD_PUSH: if(_data.size() >= PUSH_SIZE) return true; else return false;
    case CMD_QUERY: if(_data.size() >= PUSH_SIZE) return true; else return false;
    case CMD_QUERYHIT: if(_data.size() >= QUERYHIT_SIZE) return true; else return false;
    }
  
  return false;
}




