#include "Gnutella.h"
#include "Pong.h"
#include "Message.h"

Pong::Pong(const uint8_t ttl, const uint8_t hops, const std::string id, Address& address, const uint32_t files, const uint32_t kbytes)
  : _id(id), _ttl(ttl), _hops(hops), _files(files), _kbytes(kbytes), _address(address)
{
  toString();
}


Pong::Pong(const uint8_t ttl, const uint8_t hops, const std::string id, const std::string payload)
  : _id(id), _ttl(ttl), _hops(hops)
{
  uint32_t  ip   = *((uint32_t*)payload.substr(2, 4).c_str());
  uint16_t  port = *((uint16_t*)payload.substr(0, 2).c_str());
  
  _files  = *((uint32_t*)payload.substr(6, 4).c_str());
  _kbytes = *((uint32_t*)payload.substr(10,4).c_str());

  _address = Address(ip, port);

  toString();
}


Pong::~Pong()
{
}

void Pong::toString()
{
  uint16_t port    = _address.port();
  uint32_t ip      = _address.longIP();
  uint32_t payload = 14;

  _data = _id;

  _data += static_cast<char>(CMD_PONG);
  _data += static_cast<char>(_ttl);
  _data += static_cast<char>(_hops);

  _data.append( Message::uint_str(payload) );

  _data.append( Message::uint_str(port) );
  _data.append( Message::uint_str(ip) );
  _data.append( Message::uint_str(_files) );
  _data.append( Message::uint_str(_kbytes) );
}
