#include "PongCache.h"

#include <qtimer.h>
#include "Pong.h"
#include "Ping.h"
#include "Servent.h"

PongCache* PongCache::_this = NULL;

PongCache::PongCache() :
  _files(0), _size(0)
{
  _expire = new QTimer(this);
  connect(_expire, SIGNAL(timeout()), SLOT(expireTimeout()));
  _expire->start(3000);
}

PongCache* PongCache::getInstance()
{
  if(_this)
    return _this;
  else
    _this = new PongCache();

  return _this;
}

PongCache::~PongCache()
{
  delete _expire;
  _this = NULL;
}

uint32_t PongCache::getSharedSize()
{
  return _size;
}

uint32_t PongCache::getHosts(unsigned int servant_number)
{
  return _nhosts[servant_number];
}

uint32_t PongCache::getNumberOfFiles()
{
  return _files;
}

void PongCache::addPong(Pong pong, unsigned int servant_number)
{
  if(pong._hops > 6) return;

  _cache[pong._hops].push_back(PongData(pong, servant_number));
  _size += (pong._kbytes);
  _files += pong._files;
  _nhosts[servant_number]++;
}

void PongCache::addHost(std::string id, unsigned int hops, unsigned servant_number)
{
  if(hops > 6) return;

  _hosts[hops].push_back(HostData(id, servant_number));
  _nhosts[servant_number]++;
}

void PongCache::expireTimeout()
{
  time_t current_time = time(NULL);

  for(int i = 0; i < 7; ++i)
    {
      std::list<PongData>::iterator pos = _cache[i].begin();

      while( pos != _cache[i].end() )
	if(pos->_time < current_time - 40)
	  {
	    _files -= pos->_pong._files;
	    _size -= pos->_pong._kbytes;
	    if(_nhosts[pos->_servant_number] > 0) _nhosts[pos->_servant_number]--;
	    pos = _cache[i].erase(pos);
	  }
	else
	  break;

      std::list<HostData>::iterator hpos = _hosts[i].begin();
      
      while( hpos != _hosts[i].end() )
	if(hpos->_time < current_time - 40)
	  {
	    if(_nhosts[hpos->_servant_number] > 0) _nhosts[hpos->_servant_number]--;
	    hpos = _hosts[i].erase(hpos);
	  }
	else
	  break;
    }
}

void PongCache::getPong(std::list<Pong>& pong_list, int n)
{
  int j = 0;

  for(int i = 6; i > 0; --i)
    {
      std::list<PongData>::iterator pos = _cache[i].begin();
      while( (pos != _cache[i].end()) && (j++ < n) ) pong_list.push_back((pos++)->_pong);
    }
}

void PongCache::clear()
{
  for(int i = 0; i < 7; ++i) 
    {
      _cache[i].clear();
      _hosts[i].clear();
    }
  _nhosts.clear();
}

void PongCache::removePong(unsigned int servant_number)
{
  for(int i = 0; i < 7; ++i)
    {
      std::list<PongData>::iterator pos = _cache[i].begin();

      while( (pos != _cache[i].end()) ) 
	if(pos->_servant_number == servant_number)
	  {
	    _files -= pos->_pong._files;
	    _size -= pos->_pong._kbytes;
	    if(_nhosts[pos->_servant_number] > 0) _nhosts[pos->_servant_number]--;
	    pos = _cache[i].erase(pos);
	  }
	else
	  ++pos;

      std::list<HostData>::iterator hpos = _hosts[i].begin();

      while( (hpos != _hosts[i].end()) ) 
	if(hpos->_servant_number == servant_number)
	  {
	    if(_nhosts[hpos->_servant_number] > 0) _nhosts[hpos->_servant_number]--;
	    hpos = _hosts[i].erase(hpos);
	  }
	else
	  ++hpos;
    }
}
