#include "Gnutella.h"
#include "Push.h"
#include "Message.h"

Push::Push(const uint8_t ttl, const uint8_t hops, std::string& id, std::string& payload)
  : _id(id), _ttl(ttl), _hops(hops)
{
  uint32_t ip   = *((uint32_t*)payload.substr(20, 4).c_str());
  uint16_t port = *((uint16_t*)payload.substr(24, 2).c_str());

  _address = Address(ip, port);
  _id_payload = payload.substr(0, 16);
  _index = *((uint32_t*)payload.substr(16, 4).c_str());

  toString();
}

Push::Push(const uint8_t ttl, const uint8_t hops, std::string& id, std::string& id_p, const uint32_t index, const Address address)
  : _id(id), _ttl(ttl), _hops(hops), _id_payload(id_p), _index(index), _address(address)
{
  toString();
}

Push::Push()
{
}

void Push::toString()
{
  uint32_t  payload = 26;
  
  _data  = _id;

  _data += static_cast<char>(CMD_PUSH);
  _data += static_cast<char>(_ttl);
  _data += static_cast<char>(_hops);

  _data.append( Message::uint_str(payload) );

  _data.append(_id_payload);
  _data.append( Message::uint_str(_index) );

  uint16_t port = _address.port();
  uint32_t ip   = _address.longIP();
  _data.append( Message::uint_str(ip) );
  _data.append( Message::uint_str(port) );
}
