#include "Gnutella.h"
#include "QueryHit.h"
#include "Errors.h"
#include "Message.h"

QueryHit::QueryHit(const uint8_t ttl, const uint8_t hops, const std::string id, const std::string data)
  : _ttl(ttl), _hops(hops), _id(id)
{
  std::string qh = data;

  uint16_t port  = *((uint16_t*)qh.substr(1, 2).c_str());
  uint32_t ip    = *((uint32_t*)qh.substr(3, 4).c_str());

  _address = Address(ip, port);
  _hits  = *((uint8_t*)qh.substr(0, 1).c_str());
  _speed = *((uint32_t*)qh.substr(7, 4).c_str());

  qh.erase(0, 11);

  _id_result = qh.substr(qh.size()-16);
  qh.erase(qh.size()-16, 16);

  //if(_id_result.size()!=16) std::cout << " WARNING WARNING WARNING " << std::endl;

  std::string::size_type pos;

  for(int hits_counter = 0; hits_counter < _hits; hits_counter++)
    {
      uint32_t index = *((uint32_t*)qh.substr(0, 4).c_str());
      uint32_t fsize = *((uint32_t*)qh.substr(4, 4).c_str());

      qh.erase(0, 8);

      pos = qh.find( std::string("\0\0", 2) );

      if(pos == std::string::npos) // delimiter not found => clear rest of query hit
	{
	  qh.erase();
	  break;
	}

      std::string fname = qh.substr(0, pos);
      qh.erase(0, pos+2);
      _results.push_back(QueryResult(index, fsize, fname));
    }


  if(qh.size()>0)  // extended query hit
    _trailer = qh;
  else
    _trailer = "";

  toString();
}



QueryHit::QueryHit(const std::string header_id, const uint8_t ttl, const uint8_t hops, Address& address, const uint32_t speed, const std::string result_id, vector<QueryResult>& results)
{
  _id = header_id;
  _ttl = ttl;
  _hops = hops;
  _hits = results.size();
  _address = address;
  _speed = speed;
  _id_result = result_id;
  _results = results;
  _trailer.assign( std::string("QTEL\2\0\0", 7) );

  toString();
}

void QueryHit::toString()
{
  _data = _id;

  _data += static_cast<char>(CMD_QUERYHIT);
  _data += static_cast<char>(_ttl);
  _data += static_cast<char>(_hops);

  std::string result;

  for(int i = 0; i < _results.size(); ++i)
    {
      result.append( Message::uint_str(_results[i].index) );
      result.append( Message::uint_str(_results[i].filesize) );
      result.append( _results[i].filename );
      result.append( std::string("\0\0", 2) );
    }

  result.append(_trailer);
  result.append(_id_result);

  uint32_t payload = result.size() + 1+2+4+4;
  uint16_t port = _address.port();
  uint32_t ip = _address.longIP();

  _data.append( Message::uint_str(payload) );

  _data.append( Message::uint_str(_hits) );
  _data.append( Message::uint_str(port) );
  _data.append( Message::uint_str(ip) );
  _data.append( Message::uint_str(_speed) );

  _data.append( result );
}

