#include "SearchViewItem.h"
#include "Connections.h"
#include "QueryHitEntry.h"
#include "QtellaSub.h"
#include "Search.h"
#include "SearchWidget.h"

#include <qlistview.h>
#include <qstring.h>

#include <stdint.h>

SearchViewItem::SearchViewItem(QListView *parent, Connections* connections)
  : QListViewItem(parent), _connections(connections), _parent(parent)
{
}


SearchViewItem::SearchViewItem(QListView *parent, Connections* connections, QListViewItem *after)
  : QListViewItem(parent, after), _connections(connections), _parent(parent)
{
}

QString SearchViewItem::key(int column, bool ascending) const
{
  switch(column)
    {
    case 4:  // filesize
    case 0:  // hit number
      return text(column).rightJustify(15, '0');
      break;

    case 1:  // status
      int  i = 0;
      int  j = 0;
      int  n_search = _connections->_search.size();
      bool found = false;

      if(!n_search) break;

      for(i = 0; i < n_search; ++i)
	if(_connections->_search[i]->sw->ui_listview_search == _parent)
	  {
	    for(j = 0; j < _connections->_search[i]->vSearchResults.size(); ++j)
	      if(_connections->_search[i]->vSearchResults[j]->item == (QListViewItem*)this ||
		 _connections->_search[i]->vSearchResults[j]->item == NULL )
		{
		  found = true;
		  break;
		}
	    break;
	  }

      if(found)
	{
	  uint32_t speed  = _connections->_search[i]->vSearchResults[j]->speed;
	  int      status = _connections->_search[i]->vSearchResults[j]->status;

	  std::string s_status;

	  if(status & QueryHitEntry::Ready) s_status = "A";
	  if(status & QueryHitEntry::Unknown) s_status = "C";
	  if(status & QueryHitEntry::Firewalled) s_status = "B";
	  if(status & QueryHitEntry::Busy) s_status = "D";
	  
	  std::strstream str;
	  str << (999999-speed) << std::ends;
	  
	  std::string s(str.str());
	  str.freeze(false);
	  while(s.size() < 10) s.insert(0, "9");
	  
	  QString ret( (s_status+s).c_str() );
	  return(ret);
	}
    }

  return text(column);
}
