#include "../include/SearchWidget.h"
#include "QtellaSub.h"
#include <qlistview.h>

/* 
 *  Constructs a SearchWidget which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
SearchWidget::SearchWidget( QWidget* parent,  const char* name, WFlags fl )
    : SearchWidgetBase( parent, name, fl )
{
  this->parent = (QtellaSub*) parent;

  ui_listview_search->setColumnWidthMode(1, QListView::Manual);
  ui_listview_search->setColumnWidthMode(2, QListView::Manual);
  ui_listview_search->setColumnWidthMode(4, QListView::Manual);
  ui_listview_search->setColumnWidthMode(6, QListView::Manual);
  ui_listview_search->setColumnWidth(1, 7*10);
  ui_listview_search->setColumnWidth(2, 35*10);
  ui_listview_search->setColumnWidth(4, 9*10);
  ui_listview_search->setColumnWidth(5, 9*10);
  ui_listview_search->setColumnAlignment(0, AlignLeft);
  ui_listview_search->setColumnAlignment(1, AlignHCenter);
  ui_listview_search->setColumnAlignment(2, AlignLeft);
  ui_listview_search->setColumnAlignment(3, AlignRight);
  ui_listview_search->setColumnAlignment(4, AlignRight);
  ui_listview_search->setColumnAlignment(5, AlignRight);
  ui_listview_search->setColumnAlignment(6, AlignRight);

  ui_listview_search->setShowSortIndicator(true);
  ui_listview_search->setSorting(2, true);        // sort filenames by default
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SearchWidget::~SearchWidget()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void SearchWidget::slotDoubleClick(QListViewItem *item)
{
  doubleClicked(item);
}

void SearchWidget::slotRightButton(QListViewItem* item, const QPoint& p, int column)
{
  rightButton(item, p, column);
}
