#include "SharedFile.h"
#include "SharedViewItem.h"

SharedFile::SharedFile(SharedViewItem *item, std::string file, std::string directory, unsigned long size, int uploads=0, int requests=0)
{
  this->file = file;
  this->directory = directory;
  this->size = size;
  this->uploads = uploads;
  this->requests = requests;
  this->item = item;
}


SharedFile::~SharedFile()
{
  delete item;
}


string SharedFile::completeFilename()
{
  std::string f = directory;
  
  if(f.size() > 0)
    if( f[f.size()-1] != '/' ) f += "/";

  f += file;
  
  return f;
}
