#include "StringManipulation.h"

#include <cctype>

StringManipulation::StringManipulation(std::string s)
{
  this->s = s;
}

void StringManipulation::remove_comments(const char c = '#')
{
  std::string::size_type  pos;

  pos = s.find_first_of(c);

  if(pos!=std::string::npos)
    s.erase(pos);
}

void StringManipulation::split(std::string &sleft, std::string &sright, const char c = '=')
{
  std::string::size_type  pos;

  pos = s.find_first_of(c);

  sleft.erase();
  sright.erase();

  if(pos!=std::string::npos)
    {
      sleft = this->s.substr(0, pos);
      sright = this->s.substr(pos+1);
    }
}

string StringManipulation::str()
{
  return s;
}

void StringManipulation::assign(std::string s)
{
  this->s = s;
}

void StringManipulation::remove_chars(std::string chars)
{
  std::string::iterator  iterator;

  for(int i=0; i<chars.size(); i++)
    for(iterator=s.begin(); iterator!=s.end(); )
      if(*iterator==chars[i])
	iterator = s.erase(iterator);
      else
	++iterator;
}

void StringManipulation::split_to_vector(vector<string> &str, const char c)
{
  string                  s = this->s;
  std::string::size_type  pos;

  while( (pos = s.find(c)) != std::string::npos )
    {
      str.push_back(s.substr(0, pos));
      s = s.substr(pos+1);
    }
  
  if(!s.empty()) str.push_back(s);
}

std::string StringManipulation::to_lower()
{
  for(int i = 0; i < s.size(); ++i) s[i] = tolower(s[i]);
  return s;
}

std::string StringManipulation::insertDelimiter(std::string str, char delimiter, int pos)
{
  std::string s(str);
  std::string del;
  del += delimiter;
  int m = s.size();
  for(int j = 1; j <= (m-1)/pos; ++j) s.insert(m-pos*j, del);
  return s;
}
