#include "UploadManager.h"
#include "QtellaSub.h"
#include "Upload.h"
#include "Push.h"

#include "qhostaddress.h"
#include "qsocket.h"
#include "qstring.h"
#include "qspinbox.h"
#include "qlistview.h"

UploadManager::UploadManager(QtellaSub *parent = 0) 
  : _parent(parent)
{
}


UploadManager::~UploadManager()
{
  std::list<Upload*>::iterator pos = upload_list.begin();

  for( pos; pos != upload_list.end(); ++pos) delete *pos;
}


int UploadManager::numberUploads()
{
  int upload_counter = int();
  std::list<Upload*>::iterator  pos = upload_list.begin();
  
  for( pos; pos != upload_list.end(); ++pos )
    if( ((*pos)->getState() == Upload::Connected) || ((*pos)->getState() == Upload::Connecting) )
      upload_counter++;
  
  return upload_counter;
}


void UploadManager::addPushUpload(Push p)
{
  upload_list.push_back(new Upload(this, p));
}


void UploadManager::addUpload(std::string data, QSocket* socket)
{
  upload_list.push_back(new Upload(this, data, socket));
}


void UploadManager::abortUpload()
{
  std::list<Upload*>::iterator  pos;

  for(pos = upload_list.begin(); pos != upload_list.end(); ++pos)
    if( _parent->ui_listview_uploads->isSelected( (*pos)->item ) )
      {
	(*pos)->abortUpload();
	break;
      }
}


void UploadManager::removeUpload()
{
  std::list<Upload*>::iterator  pos = upload_list.begin();

  while( pos != upload_list.end() )
    if( _parent->ui_listview_uploads->isSelected( (*pos)->item ) )
      {
	(*pos)->abortUpload();
	delete *pos;
	pos = upload_list.erase(pos);
      }
    else
      ++pos;
}


void UploadManager::removeInactiveUploads()
{
  std::list<Upload*>::iterator  pos = upload_list.begin();

  while( pos != upload_list.end() )
    if( ((*pos)->getState() != Upload::Start) && ((*pos)->getState() != Upload::Connected) )
      {
	delete *pos;
	pos = upload_list.erase(pos);
      }
    else
      ++pos;
}
