#ifndef ADDRESS_H
#define ADDRESS_H

#include <string>
#include <qglobal.h>

#if !defined(_WIN32)
using namespace std;
#endif

class Address
{
 public:
  Address();
  Address(std::string ip);
  Address(std::string ip, const Q_UINT16 port);
  Address(const Q_UINT32 ip);
  Address(const Q_UINT32 ip, const Q_UINT16 port);

  std::string        strIP();
  const Q_UINT16     port();
  const Q_UINT32     longIP();
  std::string        toString();
  void               setPort(const Q_UINT16 port);
  void               setPort(std::string port);
  void               setIP(std::string ip);
  bool               isPrivate();

  static std::string getIPOfHost(std::string host);

  std::string        strPort();

  bool operator==(Address& a) { return ( (a._ip == _ip) && (a._uiport == _uiport) ); }
  
 private:
  std::string        _ip;
  Q_UINT16           _uiport;
};

#endif
