//! Abstract class to read information of an audio file.
/*!
    $Author: etzi $
    $Revision: 1.3 $
    $Date: 2002/07/01 19:37:45 $
*/    

#ifndef AUDIOFILE_H
#define AUDIOFILE_H

#include "BAudioFile.h"

#include <string>

static std::string empty = "";
static std::string notpresent = "-";

class MyAudioFile
{
public:
  virtual std::string	&getTitle();
  virtual void		setTitle( std::string );
  virtual std::string	&getArtist();
  virtual void		setArtist( std::string );
  virtual std::string	&getAlbum();
  virtual void		setAlbum( std::string );
  virtual std::string	&getYear();
  virtual void		setYear( std::string );
  virtual std::string	&getComment();
  virtual void		setComment( std::string );
  virtual unsigned int	getGenre();
  virtual void		setGenre( unsigned int );
  virtual unsigned int	getTracknumber();
  virtual void		setTracknumber( unsigned int );
  virtual std::string	&getFormat();
  virtual unsigned int	getLength();
  virtual unsigned int	getBitRate();
  virtual unsigned int	getSampleRate();
  virtual std::string	&getChannelMode();
  virtual bool		valid();
  virtual bool		updateInfo( std::string );
  virtual std::string	&updateMesg();
  virtual unsigned int	getID3V1();
  virtual unsigned int	getID3V2();
  virtual void		setID3V1( bool );
  virtual void		setID3V2( bool );

protected:
  std::string	_title;
  std::string	_album;
  std::string	_artist;
  std::string	_year;
  std::string	_comment;
  unsigned int	_genre;
  unsigned int	_track;
  unsigned int	_id3v1;
  unsigned int	_id3v2;
  std::string	_channelmode;
  unsigned int	_bitrate;
  unsigned int	_samplerate;
  unsigned int	_length;
  std::string	_updatemesg;
  bool		_valid;
  std::string	_format;
};

class AudioFile : public MyAudioFile, public BAudioFile
{
public:
  AudioFile( QWidget *parent = 0,
	     const char *name = 0,
	     bool modal = FALSE,
	     WFlags fl = 0 );
  ~AudioFile();

  void setFile( std::string directroy = "",
		std::string filename = "",
		bool read = false );

  void setProperty();

  bool			read();
  // Returns the filename of this audio file.
  std::string		&getFilename()	{ return _filename; };
  std::string		&getDirectory()	{ return _directory; };

  //! Update file information(s)
  bool			updateInfo( std::string file )
			{ return _audio->updateInfo( file ); };
  // Returns message of update status
  std::string		&updateMesg()	{ return _audio->updateMesg(); };

  //! returns true if file is a valid audio file
  bool			valid()		{ return _audio->valid(); };
  // Type of audio file format
  std::string		&getFormat()	{ return _audio->getFormat(); };

  //! songname
  std::string		&getTitle()	{ return _audio->getTitle(); };
  void			setTitle( std::string str )
					{ _audio->setTitle( str ); }
  //! title of album
  std::string		&getAlbum()	{ return _audio->getAlbum(); };
  void			setAlbum( std::string str )
					{ _audio->setAlbum( str ); }
  //! artist
  std::string		&getArtist()	{ return _audio->getArtist(); };
  void			setArtist( std::string str )
					{ _audio->setArtist( str ); }
  std::string		&getYear()	{ return _audio->getYear(); };
  void			setYear( std::string str )
					{ _audio->setYear( str ); }
  std::string		&getComment()	{ return _audio->getComment(); };
  void			setComment( std::string  str )
					{ _audio->setComment( str ); }
  unsigned int		getGenre()	{ return _audio->getGenre(); };
  void			setGenre( unsigned int g )
					{ _audio->setGenre( g ); }
  unsigned int		getTracknumber(){ return _audio->getTracknumber(); };
  void			setTracknumber( unsigned int tr )
					{ _audio->setTracknumber( tr ); }
  unsigned int		getID3V1()	{ return _audio->getID3V1(); };
  void			setID3V1( bool yes )
					{ _audio->setID3V1( yes ); };
  unsigned int		getID3V2()	{ return _audio->getID3V2(); };
  void			setID3V2( bool yes )
					{ _audio->setID3V2( yes ); };

  //! bitrate in kbit
  unsigned int		getBitRate()	{ return _audio->getBitRate(); };
  //! sample rate in HZ
  unsigned int		getSampleRate() { return _audio->getSampleRate(); };
  //! length of audio file in seconds
  unsigned int		getLength()	{ return _audio->getLength(); };
  //! Channel mode (stereo, mono, ... )
  std::string		&getChannelMode(){ return _audio->getChannelMode(); };

public slots:
  virtual void		slotUpdateAudioFile();
  virtual void		slotID3Checkbox( int );

protected:
  MyAudioFile *	_audio;

  std::string	_filename;
  std::string	_directory;
  bool		_read;

private:
  std::string	sec2hour( unsigned int secs );
  void		setChangable( bool );
};

#endif // AUDIOFILE_H
