#ifndef CONNECTIONS_H
#define CONNECTIONS_H

#include "qobject.h"
#include <qiconset.h>
#include <qtimer.h>

#include "Statistic.h"
#include "Address.h"

class QtellaSub;
class QListViewItem;
class QWidget;
class QTimer;
class QDateTime;
class QSocket;
class Search;
class Servent;
class QueryHitEntry;
class SearchWidget;
class Search;
class Message;
struct SearchParameters;

#include <vector>
#include <string>
#include <ctime>
#include <list>

#if !defined(_WIN32)
using namespace std;
#endif

class Connections : QObject
{
  Q_OBJECT

 public:
  Connections(QtellaSub *parent = 0);
  ~Connections();

  static Connections* getInstance();

  void               start();
  void               search(std::string query, SearchWidget *sw, const SearchParameters *sp = NULL);
  void               sendSearch(const Search &);
  void               checkServants();
  void               checkMessages(Servent* servant);
  void               disconnect();
  std::string        createID();
  static std::string toHex(std::string data);
  void               addServant(Address address, QSocket* socket = NULL, 
                                const std::string& user_agent = "", const std::string& handshake = "");
  void               sendAll(std::string data);

  //! returns true if host is blocked else false
  const bool         hostBlocked( const std::string& ip );

  //! increase number of packets which were thrown away because too many arrived
  const void         incIgnoredPackets();

  //! increase the number of all incoming packets
  const void         incAllPackets();

  std::vector<Search*>     _search;
  std::vector<Servent*>    _servants;

  std::string         _id;
  QtellaSub*          _parent;
  Statistic           _statistic;
  Address             _address;

  const bool         incomingSlotsFree();
  const void         closeSocket( QSocket* );

 protected:
  static Connections*        _this;

  unsigned long       _blocked_packets;
  unsigned long       _all_packets;
  unsigned long       _ignored_packets;

  int                 _max_servants;
  int                 _max_hosts;
  QTimer*             _statistic_timer;
  QDateTime*          _uptime;
  QTimer*             _timer;
  QTimer              _resubmitQueriesTimer;

  std::list<std::pair<time_t, QSocket*> > _sockets_to_close;

  // < time of message, < number of files, size of files > >
  std::list< std::pair< time_t, std::pair< unsigned long, unsigned long > > > _buffer;

 private:
  //! order is important for correct sorting the search results
  static int     GREEN;
  static int     GRAY;
  static int     YELLOW;
  static int     RED;

  QPixmap              _speed_bar[63][4];


 public slots:
  void     check();
  void     slotRemoveHost();
  void     slotAddHost();
  void     slotMaxServents(int value);
  void     slotListClear();
  void     slotListRemove();
  void     slotListConnect();
  void     slotUpdateStatistic();
  void     slotBlockHost();
  void     slotShowHandshake();
  void     slotResubmitQueries();
};

#endif
