#ifndef DOWNLOADMANAGER_H
#define DOWNLOADMANAGER_H

#include <qobject.h>
#ifndef SHARP
#include <qthread.h>
#endif

#include <vector>
#include <string>

#include "InterruptedFile.h"

class QTimer;
class QListViewItem;
class QueryHitEntry;
class QtellaSub;
class QSocket;

class Download;
/* class MergeDialog; */

#if !defined(_WIN32)
using namespace std;
#endif

class DownloadManager : public QObject
{
 Q_OBJECT

public:
 DownloadManager(QtellaSub* parent);

 //! Add download.
 /*!
   \param qhe Object of the search result. qhe.item sould set to NULL.

   \param item Pointer to the item in the search list.

   \param dest new The destination filename for completed and incompleted
   download (without directory).

   \param dest_dir Directory into which the completed download is saved.

   \param int_item If this is a resumed download this pointer shows to the
   item in the interrupted file list, otherwise set to NULL.

   \param start_new If true a new download will be started if a segmented
   could not be started.
 */
 void              addDownload(QueryHitEntry& qhe, 
			       QListViewItem* item, 
			       std::string    dest = "", 
			       QListViewItem* int_item = NULL, 
			       std::string    dest_dir = "",
			       const bool     start_new = true);

 //! Download files with same size as segmented downloads.
 /*!
   All files in this vector have the same size. The merged file will be
   saved into the default directory specified in the configuration tab.
 */
 void              addDownload(std::vector<QueryHitEntry*>);

 //! Returns the number of active downloads.
 int               numberOfDownloads( const bool lock_mutex = true );

 void              abortDownload(QueryHitEntry& qhe);
 void              deleteDownload(QueryHitEntry& qhe);
 void              removeDownload(QueryHitEntry& qhe);
 bool              exists(QueryHitEntry& qhe);

 void              updatePush(std::string data, QSocket* socket);


 QtellaSub*                  _parent;
 std::vector<Download*>      _downloads;

private:
 friend class Download;

/*  //! Merge files with the given filesize */
/*  void mergeDownloads(const unsigned long filesize); */

 //! Returns a vector of segments which have not been downloaded yet.
 /*!
   Since this method is based on getFinishedSegments it is possible
   that some of these segments are being downloaded by an active
   download.
 */
 void getUnfinishedSegments(const unsigned long filesize, 
			    std::vector< std::pair< unsigned long, unsigned long> >& segments);

 //! Returns a list of interrupted files for which bytes have been read.
 /*!
   The list is sorted by start offset. Active downloads for these files
   may exist.
 */
 void getFinishedFiles(const unsigned long filesize, std::vector< InterruptedFile >& files);

 //! Get a list of segments for which no download in the download tab exist.
 void getFreeSegments(const unsigned long filesize, 
		      std::vector< std::pair< unsigned long, unsigned long > >& segments);


 QTimer*                     _update_timer;

#ifndef SHARP
 //! Mutex to access _downloads
 static QMutex               _mutex;
#endif

 //! Is called by a Download which has been finished.
 void downloadFinished(Download* download);

public slots:
  void              slotUpdate();
  void              slotAbortDownload();
  void              slotResumeDownload();
  void              slotRemoveDownload();
  void              slotClearInactive();
  void              slotDelete();
  void              slotMoveDownloads();

  void              slotDownloadProperties();
};

#endif
