// -*- C++ -*-
#ifndef G_WEB_CACHE_MANAGER_H
#define G_WEB_CACHE_MANAGER_H

#include <qlist.h>
#include <qobject.h>
#include <qtimer.h>
#include <qurloperator.h>

#include "GWebCache.h"

class HttpTransactor;
class Qtella;

/*! This implements the GWebCache (caching and exchange of active node
 * lists through the web).
 */

class GWebCacheManager: private QObject {
      Q_OBJECT
    public:
      explicit GWebCacheManager(Qtella *interface);
      void addCache(const char *url);
      GWebCache *get();
      void rotateCache();
      void requestHosts();
      
    private slots:
      void sendUpdate();
      void sendingUpdateFinished(const QNetworkOperation &, const HttpTransactor &);
      void requestingHostsFinished(const QNetworkOperation &, const HttpTransactor &);

    private:
      Qtella *_interface;
      QList<GWebCache> _list;
      QTimer _sendUpdate;
      HttpTransactor *_sendUpdateTransaction, *_requestHostsTransaction;

};

#endif
