#ifndef HASH_TABLE
#define HASH_TABLE

#include <vector>
#include <list>
#include <string>

class HashTable
{
 public:

  HashTable();

  void         insert(const std::string& value);
  bool         find(const std::string& value);
  void         remove(const std::string& value);
  void         clear();

  void         toString();

 private:
  unsigned     hash_value(const std::string& value);
  void         lower(const std::string& src, std::string& dst);

  std::vector< std::list<std::string> > _vector;
  int                                   _n;
};

#endif
