// -*- C++ -*-
#ifndef HTTP_TRANSACTOR_H
#define HTTP_TRANSACTOR_H

/* ! Perform an HTTP query, get the headers and body of the reply */

#include <qobject.h>
#include <qurloperator.h>

class QNetworkOperation;

class HttpTransactor: public QObject {
      Q_OBJECT

    public:
      HttpTransactor();
      //! Return true if success, false otherwise
      bool start(const QString &url);
      const QString &reply() const { return _reply; }

    private slots:
      void data(const QByteArray &data, QNetworkOperation *op);
      void finished(QNetworkOperation *op);

    signals:
      void finished(const QNetworkOperation &networkStatus, const HttpTransactor &);

    private:
      QUrlOperator _operator;
      QString _reply;
      
};

#endif // HTTP_TRANSACTOR_H
