#ifndef IN_CONNECTION_H
#define IN_CONNECTION_H

#include <qobject.h>
#include <string>

class QTimer;
class QSocket;

class InConnection : public QObject
{
  Q_OBJECT

public:
  InConnection(int socket);
  ~InConnection();

  int          state();

  enum
  {
    Connected,
    Closed
  };

private slots:
  void         slotReadyRead();
  void         slotTimeout();

private:
  bool         _v06_ok;
  int          _state;
  QSocket*     _socket;
  QTimer*      _timeout;
  std::string  _rec;
  std::string  _user_agent;
  std::string  _v06_header;
};

#endif
