#ifndef INTERRUPTED_DOWNLOADS_H
#define INTERRUPTED_DOWNLOADS_H

#include "InterruptedFile.h"
#include "QueryHitEntry.h"

#include <string>
#include <map>
#include <vector>

#include <qobject.h>
#include <qpoint.h>
#include <qthread.h>

class QtellaSub;
class InterruptedViewItem;
class QPopupMenu;

class InterruptedDownloads : public QObject
{
  Q_OBJECT

 public:
  InterruptedDownloads(QtellaSub* parent, std::string directory);

  static InterruptedDownloads* getInstance();

  void         getSelectedFiles(std::vector<InterruptedFile>& files);

  //! Get all interrupted files.
  /*!
    \param files vector of all interrupted files
    \param force_update if set true it updates the internal file list first
  */
  void         getFiles(std::vector<InterruptedFile>& files, const bool force_update = false);

  void         newQueryHit(unsigned long filesize);
  void         removeQueryHit(unsigned long filesize);

  void         setYellow(InterruptedViewItem* item);
  void         setRed(InterruptedViewItem* item);
  void         setGreen(InterruptedViewItem* item);
  void         setSmile(InterruptedViewItem* item);
  void         setGreenSmile(InterruptedViewItem* item);

  void         clearColored(InterruptedViewItem* item);
  //! Convert filename format from version < 0.3.5 to 0.3.5
  void         convertFilenames();

  //! Add an interrupted download. Is called by Download::Run()
  const void   addInterruptedDownload( const std::string& filename, const Q_UINT32 index, const Q_UINT16 port );

  //! Delete interrupted download from index file.
  const void   deleteFromIndex( const std::string& filename );

  const void   getFileInformation( const std::string& filename,
				   std::map< std::string, std::string >& dst);

 private:
  //! Deletes the item from list and reorganizes the list.
  void         deleteItem(InterruptedViewItem* item);

  void         updateBall(InterruptedViewItem* item);

  std::map<InterruptedViewItem*, InterruptedFile>  _file_map;
  std::map<InterruptedViewItem*, QueryHitEntry>    _qhe;

  QtellaSub*                       _parent;
  std::string                      _directory;
  QPopupMenu*                      _context_menu;
  static InterruptedDownloads*     _this;

 public slots:
  virtual void      slotShowContextMenu(InterruptedViewItem*, const QPoint&, int);

  virtual void      deleteSelectedFiles();
  virtual void      resumeSelectedFiles();
  virtual void      searchSelectedFiles();
  virtual void      abortSelectedFiles();
  virtual void      resumeFromHost();
  void              update();

#ifndef SHARP  
 private:
  //! mutex to access the index file
  static QMutex     _index_mutex;
#endif
};

#endif
