#ifndef INTERRUPTED_FILE_H
#define INTERRUPTED_FILE_H

#include <string>
#include <ctime>

#include <qglobal.h>

class InterruptedFile
{
 public:
  InterruptedFile(std::string file);

  const std::string           filename();
  const std::string           ext();
  const std::string           strsize(bool comma = true);
  //! Returns the original complete file size. This may differ from the number of bytes which should be read.
  const unsigned long         size();
  const std::string           strprogress(int precision = 1);
  const double                progress();
  //! Number of bytes which have been already read.
  const unsigned long         read();
  const unsigned long         toread();
  const std::string           ip();
  const bool                  isValid();
  //! Returns the directory + temporary file name
  const std::string           completeName();
  //! Returns the position where the download has been started.
  const unsigned long         start();
  //! Returns the position where the download should stop.
  const unsigned long         end();
  //! Returns the id of the file from time and randomly generated number.
  const std::string           id();
  //! Extract id from the given filename.
  static const std::string    id(std::string filename);
  //! Split an id into time and randomly generated number.
  static const void           split(const std::string s, time_t& time, unsigned& id);
  //! Returns the IP of the host.
  const std::string           host();
  //! Returns the index of the file.
  const int                   index();
  //! Returns the port.
  const Q_UINT16              port();

  //! Increments the number of query hits which are equal to this file.
  const void             incFound();

  //! Decrements the number of query hits which are equal to this file.
  const void             decFound();

  const void             setColored();

  const void             clearColored();

  const int              getColored();

  const int              getFound();

 private:
  std::string            _filename;
  int                    _found;
  int                    _colored;
};

#endif
