#ifndef MESSAGE_H
#define MESSAGE_H

#include <string>
#include <vector>
#include <qglobal.h>

class Ping;
class Pong;
class Query;
class QueryHit;
class Push;
class Bye;

#if !defined(_WIN32)
using namespace std;
#endif

class Message
{
 public:
  Message( const std::vector< char >& data );
  Message( const std::string& data );

  Message();
  ~Message();

  const Q_UINT8       cmd();
  const Q_UINT8       ttl();
  const Q_UINT8       hops();
  const Q_UINT32      payload();
  const Q_UINT32      size();
  std::string         id();
  std::string         data();
  const bool          isValid();

  static std::string  uint_str(Q_UINT32 value);
  static std::string  uint_str(Q_UINT16 value);
  static std::string  uint_str(Q_UINT8 value);

  static Q_UINT16  str_uint16(std::string str);
  static Q_UINT16  str_uint16(const char *str);
  static Q_UINT32  str_uint32(std::string str);
  static Q_UINT32  str_uint32(const char *str);

  static Q_UINT32  str_uint32( const std::vector<char>& v, const unsigned beg );

  void          dec_ttl();
  void          inc_hops();

  Ping*         getPing();
  Pong*         getPong();
  Query*        getQuery();
  QueryHit*     getQueryHit();
  Push*         getPush();
  Bye*          getBye();

 private:
  std::string   _data;
  std::string   _payload_data;
  std::string   _id;
  Q_UINT8       _ttl;
  Q_UINT8       _hops;
  Q_UINT8       _cmd;
  Q_UINT32      _payload;
  bool          _valid;
};

#endif
