#ifndef QTELLASUB_H
#define QTELLASUB_H

#include <string>
#include <vector>
#include <list>
#include <set>

#ifndef SHARP
class HostCache;
#endif

class Connections;
class SharedFile;
class UploadManager;
class DownloadManager;
class IncomingConnect;
class InterruptedDownloads;
class QMenuBar;
class QPopupMenu;
class QCloseEvent;
class QListViewItem;
class QListBoxItem;
class QTimer;
class ExecThread;
class GWebCacheManager;
class QWorkspace;
struct SearchParameters;

class WidgetConnections;
class WidgetSearch;
class WidgetDownloads;
class WidgetUploads;
class WidgetSharedFiles;
class WidgetConfig;
class WidgetInterrupted;
class WidgetStats;
class WidgetLogs;

#ifndef SHARP
#include "qthread.h"
#endif
#include <qapplication.h>
#include <qstring.h>
#include <qfont.h>
#include <qpalette.h>

#include "Qtella.h"
#include "HashTable.h"

#ifdef USEKDE
#include "kmenubar.h"
#include "kpopupmenu.h"
#endif

#if !defined(_WIN32)
using namespace std;
#endif

// currently these definitions are only interesting for the Zaurus port
#define CONNECTIONS_ICON_ID 500
#define SEARCH_ICON_ID      501
#define DOWNLOAD_ICON_ID    502
#define UPLOAD_ICON_ID      503
#define SHARED_ICON_ID      504
#define STATS_ICON_ID       505
#define INTERRUPTED_ICON_ID 506
#define CONFIG_ICON_ID      507
#define HELP_ICON_ID        508

class QtellaSub : public Qtella
{ 
  Q_OBJECT 

 public:
    QtellaSub( QApplication* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~QtellaSub();

#ifdef USEKDE
    KMenuBar*            menu;
    KPopupMenu*          _help;
    KPopupMenu*          _file;
    KPopupMenu*          _style;
/*     KPopupMenu*          _view; */
#endif

#ifdef QT
    QMenuBar*            menu;
    QPopupMenu*          _help;
    QPopupMenu*          _file;
#ifndef SHARP
    QPopupMenu*          _style;
#endif
/*     QPopupMenu*          _view; */
#endif

    Connections*         connections;
    QTimer*              timer_connection;
    
    std::vector< std::pair<std::string, std::string> > _applications;
    std::vector<SharedFile*>  vSharedFiles;

    unsigned long             number_shared_files;
    double                    shared_size;

    static void               sighandler( int );
    void                      checkDirectories( const std::string& directory, std::vector<SharedFile*>* old );
    void                      removeFiles( const int size );
    void                      launchFile( const std::string& filename );
    void                      launchFileList( std::vector<std::string>& files );
    static QtellaSub*         getInstance();
    const void                search( const std::string& query, const SearchParameters * = NULL);
    const void                setReportedIP( const std::string& ip );

    UploadManager*            upload_manager;
    DownloadManager*          download_manager;
    IncomingConnect*          _incoming_connect;
    InterruptedDownloads*     _interrupted_downloads;
    
    GWebCacheManager          *_gWebCache;

    HashTable                 _hash_table;
    std::set<unsigned long>   _sharedsize_set;

    QPopupMenu*               _context_download;
    QPopupMenu*               _context_search;
    QPopupMenu*               _context_upload;
    QPopupMenu*               _context_shared;
    QPopupMenu*               _context_connect;

    int                       _search_column_size;
    unsigned                  _current_port;
    std::string               _last_download_to_dir;
    bool                      _incoming_allowed;
    bool                      _use_opensourcep2p;
    std::string               _hostlist_file;

    const int                 strtoint(const std::string& s);

    const std::string         getMyAddress();

    //! Connection widget.
    WidgetConnections*        _widget_connections;

    //! Search widget.
    WidgetSearch*             _widget_search;

    //! Download widget.
    WidgetDownloads*          _widget_downloads;

    //! Upload widget.
    WidgetUploads*            _widget_uploads;

    WidgetStats*              _widget_stats;

    WidgetSharedFiles*        _widget_shared;

    WidgetInterrupted*        _widget_interrupted;

    WidgetConfig*             _widget_config;

    WidgetLogs*               _widget_logs;

 public slots:

    virtual void slotSharedFilesLaunch(QListViewItem* item);
    virtual void slotSharedFilesLaunch();
    virtual void slotAddApplication();
    virtual void slotRemoveApplication();
    virtual void slotEditApplication();
    virtual void slotChangeFinishedAny();
    virtual void slotChangeFinishedAudio();
    virtual void slotChangeFinishedImage();
    virtual void slotChangeFinishedVideo();
    virtual void slotChangeInterrupted();
    //virtual void slotChangeHostlist();
    virtual void slotChangeLogfile();
/*     virtual void slotSelectHostCacheLogFile(); */
    virtual void slotDeleteDownload();
    virtual void slotCloseSearch();
    virtual void slotLaunchInterruptedFile();
    virtual void slotDeleteInterruptedFile();
    virtual void slotSearchInterruptedFile();
    virtual void slotResumeInterruptedFile();
    virtual void slotAbortInterruptedFile();
    virtual void slotAddBlockedHost();
    virtual void slotDeleteBlockedHost();
    virtual void slotUploadBlockHost();
    virtual void slotSearchRemoveDownload();
    virtual void slotSearchDeleteDownload();
    //virtual void slotViewChanged(int);
    virtual void slotChangeHostlistFile();

    //! add all selected hosts to the blocked host list
    void slotBlockHost();

    //! clear logs from list but not from file
    virtual void slotClearLog();

    void slotConnect();
    void slotDisconnect();
    void slotSettings();

    void check_connections();
    void slotInfo();

    void slotMenu( int id );

    virtual void slotDownloadDoubleClicked(QListViewItem* item);
    virtual void slotDownloadShowContext(QListViewItem*, const QPoint&, int);
    virtual void slotLaunchSelectedDownloadItem();
    virtual void slotShowSearchContext(QListViewItem*, const QPoint&, int);
    virtual void slotShowUploadContext(QListViewItem*, const QPoint&, int);
    virtual void slotShowSharedContext(QListViewItem*, const QPoint&, int);
    virtual void slotSharedProperties();
    virtual void slotChangeInterface(const QString& text);
    virtual void slotClickedAutoConnect(int, QListBoxItem*, const QPoint&);
    virtual void slotConnectContext(QListViewItem*, const QPoint&, int);
    virtual void slotInterruptedFileContext(QListViewItem*, const QPoint&, int);
    virtual void slotRefreshSharedList();

    virtual void slotAddDirectory();
    virtual void slotRemoveDirectory();
    virtual void slotApplyConfig();
		virtual void slotCancelConfig();
    virtual void slotStopSearch();
    virtual void slotCurrentChanged(QWidget*);

		//! context menu selection: "Add to AutoConnect"
    virtual void slotAddHostAutoConnect();
		//! button of connections: "Add" (in AutoConnect Hosts)
    virtual void slotAddAutoConnect();
		//! button of connections: "Remove" (in AutoConnect Hosts)
    virtual void slotRemoveAutoConnect();
		//! button of connectoins: "Update" (in AutoConnect Hosts)
    virtual void slotUpdateAutoConnect();
		//! button of connections: "Add" (in connected hosts)
    virtual void slotAddHost();
		//! button of connections: "Read File" (in Hostlist)
    virtual void slotReadFile();

		//! button of search: "Search"
    virtual void slotSearch();
		//! combobox of search when activated is emited
		virtual void slotSearch( const QString& s );
		//! button of search: "Stop"
    virtual void slotSearchStopDownload();
		//! button of search: "Resubmit Search"
    void         slotResubmitSearch();
		//! button of search: "Download" - download all selected items
    virtual void slotDownloadAll();

    virtual void slotDownloadTo();
    virtual void slotSearchDoubleClicked(QListViewItem*);

    virtual void slotAbortUpload();
    virtual void slotRemoveUpload();
    virtual void slotDeleteSharedFile();
    virtual void slotClearInactiveUploads();
    virtual void slotRenameSharedFile();
    virtual void slotGroupSize(int);

/*     virtual void slotHostCacheChangePort(int port); */
/*     virtual void slotHostCacheChangeEnable(); */
    
    virtual void closeEvent(QCloseEvent *); /* system tray patch */

    void         slotStylePlatinum();
    void         slotStyleWindows();
    void         slotStyleMotif();
    void         slotStyleMotifPlus();
    void         slotStyleCDE();
    void         slotStyleSGI();
    void         slotStyleKDE();
    void         slotStyle(int style);
    void         slotChangeFont();
    void         slotConvertFilenames();
    void         slotIPUpdate();

 private:
    friend class Download;
    friend class Connections;
    friend class QueryHitEntry;

		QWorkspace*  _workspace;

    //! Set to save the pointers of items of all searches.
    /*!
      This set is used by the class Download to check whether
      the pointer of a download is still valid to update the
      status of the ball.
    */
    std::set<QListViewItem*>  _search_item_set;

    //! Sends the command to the DownloadManager to download a file.
    /*!
      This method is called by: <br>
      \sa slotSearchDoubleClicked(QListViewItem *item),
      \sa slotDownloadAll(),
      \sa slotDownloadTo()

      \param item Selected item in the search tab.

      \param dir Destination directory for the completed download. This
      directory is only valid during the current session. If Qtella crashes
      and later the download is resumed from the interrupted download list
      Qtella will save the complete file into the directory specified in the
      configuration tab. By default this directory is empty and the download
      is saved into the directory specified in the configuration tab.
    */   
    void                      downloadItem(QListViewItem *item, const std::string& dir = "");

    void                      readConfiguration();
    void                      readHostList();

    std::string               _pref_if;
    std::string               _last_addr;

    std::string               _binary;
    std::string               conffile;
    int                       search_tabs;
    bool                      _read_config;
    bool                      _show_delete_dialog;

    static QtellaSub*         _instance;

    std::string               _prev_version;
    QTimer*                   _ip_update_timer;

#ifndef SHARP
    QMutex                    mutex_shared_files;
    QFont                     _current_font;
    std::string               _style_s;
    QPalette                  _palette;
    QPalette                  _menu_palette;
    HostCache*                _hostcache;
#endif
};

#endif // QTELLASUB_H
