#ifndef QUERYHIT_H
#define QUERYHIT_H

#include "QueryResult.h"
#include "Address.h"

#include <vector>

#if !defined(_WIN32)
using namespace std;
#endif

class QueryHit
{
 public:
  QueryHit(Q_UINT8 ttl, Q_UINT8 hops, std::string id, std::string data);

  QueryHit(std::string header_id, const Q_UINT8 ttl, const Q_UINT8 hops, Address& address, 
		   const Q_UINT32 speed,
		   std::string result_id, std::vector<QueryResult>& vQueryResult);

  std::string       &data() { return _data; }

  Q_UINT8           ttl() const;
  bool              isValid();

 public:
  Q_UINT8                   _hits;
  Q_UINT32                  _speed;
  std::string               _id;
  std::string               _id_result;
  std::string               _trailer;

 private:
  std::string               _data;

 public:
  std::vector<QueryResult>  _results;
  Address                   _address;

 private:
  void                      toString(const std::string &id, Q_UINT8 ttl, Q_UINT8 hops);
  void                      toStringStartOfPacket(const std::string &id, Q_UINT8 ttl, Q_UINT8 hops);
  bool                      _valid;
};

#endif
