#ifndef QUERYHITENTRY_H
#define QUERYHITENTRY_H

class QListViewItem;

#include <string>
#include "Address.h"

#if !defined(_WIN32)
using namespace std;
#endif

class QueryHitEntry
{
 public:
  QueryHitEntry();
  QueryHitEntry(std::string& filename, const Q_UINT32 size, const Q_UINT32 index, const Q_UINT32 speed, int status, Address& addr, std::string& id, QListViewItem *item);
  ~QueryHitEntry();

  bool operator==(QueryHitEntry& q) { return( (filename==q.filename) && (size==q.size) && (index==q.index) ); };

  bool              firewalled();
  
  //! Filename of QueryHit.
  std::string       filename;

  //! Size of file.
  Q_UINT32          size;

  //! Index of file.
  Q_UINT32          index;

  //! Download speed of host.
  Q_UINT32          speed;

  //! Address of host.
  Address           addr;

  //! Status of host
  int               status;

  //! Gnutella ID of host.
  std::string       id;

  //! Pointer to item in QListView of search results.
  QListViewItem*    item;

  static const int  Busy;
  static const int  Ready;
  static const int  Firewalled;
  static const int  Unknown;
};

#endif
