#ifndef __RIFFFILE_H
#define __RIFFFILE_H

#include <stack>
#include <string>
#include <vector>

#include <fstream>
using namespace std;

class RiffFile;

class RiffChunk
{
public:
    char		name[5];
    unsigned long	size; 		// the length, read from the second
					// chunk header entry
    char		subType[5]; 	// valid for RIFF and LIST chunks
    long		start; 		// the file offset in bytes of the
					// chunk contents
    long		after; 		// the start of what comes after this
					// chunk

    // initialize at the file's current read position, and mark the file as bad
    // if there's an error.
    RiffChunk() {};
    RiffChunk(RiffFile& parent);

};

class RiffFile {
	ifstream	file;

	unsigned long	formSize;

	std::stack<RiffChunk, std::vector<RiffChunk> > chunks;

public:
	RiffFile(const char *name);
	~RiffFile();

	bool		rewind();
	bool		push(const char* chunkType = 0);
	bool		pop();
	long		chunkSize() const;
	const		char* chunkName() const;
	const char*	subType() const;
	bool		getNextExtraItem(int *type, std::string& value);
	std::string	getItemName( int type );
	ifstream	*filep() { return &file; };

protected:
	bool		readExtraItem(int *type, std::string& value);
};

#endif
/* __RIFFFILE_H */
