#ifndef SHA1COMPUTER_H
#define SHA1COMPUTER_H

#include <qqueue.h>
#include <qstack.h>
#include <qthread.h>
#include <string>

class SharedFile;

static const int SHA1_BASE32_SIZE = 32;

//! A structure to pass results from SHA1Computer back to the caller.

struct SHA1FileNameHash {
      char *_fileName;
      char _hash[SHA1_BASE32_SIZE + 1];
      
      ~SHA1FileNameHash() {
	    delete [] _fileName;
      }
};

// Qtopia does not support threads.

class SHA1Computer 
#ifndef SHARP
: private QThread 
#endif
{

  public:
      SHA1Computer();

      void queue(SharedFile *, const QString &fileName);
      //! You can check this to get a fast idea of if getResults() will return something or not.
      bool resultsAvailable() const { return _result; }
      //! Return NIL if nothing available, otherwise you must delete the result.
      QStack<SHA1FileNameHash> *getResults();

  private:
      void run();

  private:
#ifndef SHARP
      QMutex _input, _output;
#endif
      QQueue<char> _queue;
      QStack<SHA1FileNameHash> *_result;

  private:
      void processOne();
      void addResult(char *fileName, char *sha1);
};

extern SHA1Computer SHA1ComputerInstance;

#endif
