#ifndef SHA1STORAGE_H
#define SHA1STORAGE_H

#include <qdatetime.h>
#include <qdict.h>
#include <qlist.h>
#include <qobject.h>
#include <qstring.h>
#include <qtimer.h>
#include <stdint.h>

#include "SharedFile.h"

class QString;
class QTextStream;
class SHA1CacheFileLine;

//! A singleton to store and retrieve computed hashes onto disk

class SHA1Storage: private QObject {
      Q_OBJECT
  public:
      SHA1Storage();
      QString *get(SharedFile *sf);
      /*! Request the (asynchronous) computation of a SHA1 hash. The
	  hash will be put back into the SharedFile when known.
      */
      void requestSHA1Computation(SharedFile *);
      
  private:
      //! Same data as on disk, but in memory.
      QDict<QString> _cache;

     //! Name of the disk file
      QString _cacheFileName;

      // !1 Jan 1970 00:00 as a QDateTime. Useful to save / restore file last modification time
      QDateTime _originOfTime;
      
      //! If we've some pending SHA1 calculation, we use this timer to
      //! periodically check if results are available.
      QTimer _resultCollector;

      unsigned _pendingSHA1Calculations;

      //! List of SharedFile waiting for their SHA1 to be computed
      QDict<SharedFile> _pendingFile;
      
  private:
      void create(QList<SHA1CacheFileLine> *);

      //! Write one line into the cache file

      void writeLine(QTextStream &file, const QString &hash, uint32_t size, 
		     uint32_t mtime, const QString &fileName);

  private slots:
      void checkForAvailableResults();
};

extern SHA1Storage SHA1StorageInstance;

#endif
