#ifndef SEARCH_H
#define SEARCH_H

class SearchWidget;
class QueryHitEntry;

#include <string>
#include <vector>
#include <map>
#include <set>
#include <qglobal.h>

#include "QueryResult.h"

#if !defined(_WIN32)
using namespace std;
#endif

class Search
{
 public:
  Search(std::string id, SearchWidget *sw, Q_UINT16 min_speed, 
		 bool audio, bool video, bool images, bool any, bool active = true);
  ~Search();

  void mutateID(const std::string &);

  const bool                        duplicate( const Q_UINT32 ip, const QueryResult& qr );

  std::string                       id;
  std::string                       query;
  //! The same as query but in lower case.
  std::string                       query_lower;
  SearchWidget                      *sw;
  bool                              active;
  Q_UINT16                          _min_speed;
  std::vector<class QueryHitEntry*> vSearchResults;

  bool                              _audio;
  bool                              _video;
  bool                              _images;
  bool                              _any;


  //! short cut for the multimap
  typedef std::multimap< unsigned long, QueryHitEntry* > SIZEMAP;

  //! multimap to search Query-Hits by their size efficiently
  SIZEMAP                           _size_map;

  //! this map is to filter multipiple query hits
  std::map< Q_UINT32, std::set< std::string > > _multiple_filter;
};

#endif
