#ifndef SEARCHVIEWITEM_H
#define SEARCHVIEWITEM_H

#include <qlistview.h>
#include <string>

class Connections;

class SearchViewItem : public QListViewItem
{
 public:
  SearchViewItem(QListView *parent, Connections* connections);
  SearchViewItem(QListView *parent, Connections* connections, QListViewItem *after);
  SearchViewItem(QListViewItem *parent, Connections* connections, QListView* search_list);
  
  /* 
     a = column 0,
     b = column 2,
     c = column 3,
     ...
  */

  SearchViewItem( QListView* parent, Connections* connections, const char* a, const char*b,
		  const char* c, const char* d, const char* e, const char* f, const char* g );

  SearchViewItem( QListView *parent, Connections* connections, QListViewItem *after, const char* a,
		  const char* b, const char* c, const char* d, const char* e, const char* f,
		  const char* g );

  SearchViewItem( QListViewItem *parent, Connections* connections, QListView* search_list, const char* a,
		  const char* b, const char* c, const char* d, const char* e, const char* f,
		  const char* g );

#if QT_VERSION >= 300
  virtual int       compare( QListViewItem* item, int column, bool ascending ) const;
#else
  virtual QString   key(int column, bool ascending) const;
#endif

  bool              _group_parent;

  const void        setData( const char*, const char*, const char*, const char*,
			     const char*, const char*, const char* );

  const void        setState( const Q_UINT32 speed, const int state );

 private:
  Connections*      _connections;
  QListView*        _parent;

 public:
  int               _hit_counter;
  unsigned long     _size;
  std::string       _filename_original;
  std::string       _filename_lower;
  std::string       _type;
  std::string       _address;
  std::string       _agent;
  std::string       _info;

  int               _speed;
  int               _state;
};

#endif
