#ifndef SHAREDFILE_H
#define SHAREDFILE_H

#include <string>

class SharedViewItem;

#if !defined(_WIN32)
using namespace std;
#endif

class SharedFile
{
 public:
  SharedFile(SharedViewItem *item, std::string file, std::string directory, const unsigned long size, const int uploads=0, const int requests=0);

  ~SharedFile();

  std::string completeFilename();
  bool        renameFile(std::string newname);

  bool operator==(SharedFile &f) { return (f.file==file) && (f.directory==directory); };
  
  std::string        file;
  std::string        directory;
  unsigned long      size;
  int                uploads;
  int                requests;
  SharedViewItem     *item;

  //! This is a pointer to the SHA1 stored 
  QString            *_sha1;
};

#endif
