#ifndef STRINGMANIPULATION_H
#define STRINGMANIPULATION_H

#include <string>
#include <vector>

#if !defined(_WIN32)
using namespace std;
#endif

class StringManipulation
{
 public:
  StringManipulation(const std::string& s);

  void                   remove_comments(const char c = '#');
  void                   split(std::string &sleft, std::string &sright, const char c = '=');
  void                   assign(const std::string& s);
  void                   remove_chars(const std::string& chars);
  void                   split_to_vector(std::vector<std::string> &str, const char c);
  static std::string     insertDelimiter(const std::string& str, char delimiter, int pos);
  void                   extractWords(std::vector<std::string>& v, unsigned length = 3);
  const void             replace( const char c, const std::string& by );

  //! converts a long to a string with ',' inserted
  static const std::string    toString( const unsigned long value );

  std::string            to_lower();
  std::string            str();
  
 private:
  std::string s;
};

#endif
