#ifndef UPLOADMANAGER_H
#define UPLOADMANAGER_H

#include <list>
#include <string>

#include <qobject.h>

class QtellaSub;
class Upload;
class Push;
class QSocket;
class QTimer;
class QListBox;

#if !defined(_WIN32)
using namespace std;
#endif

class UploadManager : public QObject
{
 Q_OBJECT

 public:
  UploadManager(QtellaSub *parent = 0);
  ~UploadManager();

  void                   abortUpload();
  void                   removeUpload();
  void                   removeInactiveUploads();
  int                    numberUploads();
  void                   blockHost(QListBox* blockedlist);

  void                   addUpload( const std::string& data, QSocket* socket );
  void                   addPushUpload(Push p);

  const int              numberUploadsFromHost( const std::string& ip );

  QtellaSub*             _parent;
  
 private:
  std::list<Upload*>     upload_list;
  QTimer*                _timer;

 private slots:
  void                   slotTimer();
};

#endif
