#include "Address.h"

#include <qhostaddress.h>
#include <qdns.h>
#include <qvaluelist.h>
#include <qglobal.h>

#include <iostream>
#include <strstream>
#if !defined(_WIN32)
#include <netdb.h>
#endif

Address::Address()
{
  QValueList<QHostAddress> list;

  if(list.isEmpty())
    _ip = "0.0.0.0";
  else
    _ip = list.first().toString().latin1();

  _uiport = 0;
}

Address::Address(const std::string ip)
{
  std::string::size_type Idx = ip.find(":");
  if(Idx == std::string::npos)
    {
      _ip = ip;
      _uiport = 0;
    }
  else
    {
      _ip = ip.substr(0, Idx);
      _uiport = atol((ip.substr(Idx+1)).c_str());
    }
}

Address::Address(const std::string ip, const Q_UINT16 port)
{
  _ip = ip;
  _uiport = port;
}

Address::Address(const Q_UINT32 ip)
{
  std::strstream str;

  str << (ip&0xff) << "." << ((ip>>8)&0xff) << "." << ((ip>>16)&0xff)
      << "." << ((ip>>24)&0xff) << std::ends;

  _ip = str.str();
  _uiport = 0;
  
  str.freeze(false);
}

Address::Address(const Q_UINT32 ip, const Q_UINT16 port)
{
  std::strstream str;

  str << (ip&0xff) << "." << ((ip>>8)&0xff) << "." << ((ip>>16)&0xff)
      << "." << ((ip>>24)&0xff) << std::ends;

  _ip = str.str();
  _uiport = port;

  str.freeze(false);
}

std::string Address::strIP()
{
  return _ip;
}

const Q_UINT32 Address::longIP()
{
  std::string::size_type  idx;
  std::string             ip = _ip;
  Q_UINT32                lip = 0;
  int                     shift = 0;

  while( (idx = ip.find(".")) != std::string::npos )
    {
      std::strstream str;
      int       i;
      str << ip.substr(0, idx) << std::ends;
      str >> i;
      lip |= (i<<shift);
      shift += 8;
      ip = ip.substr(idx+1);
    }

  std::strstream str;
  int       i;
  str << ip;
  str >> i;
  lip |= i<<shift;

  return lip;
}

void Address::setPort(const Q_UINT16 port)
{
  _uiport = port;
}

void Address::setPort(const std::string port)
{
  std::strstream str;
  str << port << std::ends;
  str >> _uiport;
}

void Address::setIP(const std::string ip)
{
  _ip = ip;
}

const Q_UINT16 Address::port()
{
  return _uiport;
}

std::string Address::toString()
{
  std::strstream str;

  str << _ip << ":";
  str << _uiport << std::ends;

  std::string s(str.str());
  str.freeze(false);

  return s;
}

std::string Address::strPort()
{
  std::strstream str;
  str << _uiport << std::ends;

  std::string s = str.str();
  str.freeze(false);

  return s;
}


bool Address::isPrivate()
{
  Q_UINT32 ip = longIP();

  // 10.0.0.0/8
  // 172.16.0.0/12
  // 192.168.0.0/16
  // 127.0.0.0/8

  if(!ip) return true;

  return ( ((ip&0x000000ff)==0x0000000a) || ((ip&0x0000ffff)==0x0000a8c0) || ((ip&0x0000ffff)==0x000010ac) 
	   || ((ip&0x0000007f==0x0000007f)) );
}


std::string Address::getIPOfHost(std::string host)
{
  std::string addr = "0.0.0.0";

#if !defined(_WIN32)
  if( host.empty() ) return addr;

  struct hostent* he = gethostbyname(host.c_str());

  if( he )
    if( he->h_length )
      {
	unsigned char a[4] = {he->h_addr[0], he->h_addr[1], he->h_addr[2], he->h_addr[3]};

	std::strstream str;
	str << (int)a[0] << "." << (int)a[1] << "." << (int)a[2] << "." << (int)a[3] << std::ends;
	addr = str.str();
	str.freeze(false);
      }
#endif

  return addr;
}
