//! Abstract class to read information of an audio file.
/*!
    $Author: etzi $
    $Revision: 1.5 $
    $Date: 2002/07/28 11:47:50 $
*/    

#include "StringManipulation.h"
#include "AudioFile.h"

#include "AudioUnknown.h"
#include "AudioMp3.h"
#include "AudioWav.h"
#include "AudioOgg.h"
#include "AudioGenre.h"

#include <iostream>
#include <strstream>
#include <iomanip>
#include <qlabel.h>
#include <qfile.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qbutton.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

unsigned int MyAudioFile::getLength()
{
  return 0;
}
bool MyAudioFile::valid()
{
  return false;
}
std::string &MyAudioFile::getTitle()
{
  return notpresent;
}
void MyAudioFile::setTitle( std::string str )
{
  return;
}
std::string &MyAudioFile::getArtist()
{
  return notpresent;
}
void MyAudioFile::setArtist( std::string str )
{
  return;
}
std::string &MyAudioFile::getAlbum()
{
  return notpresent;
}
void MyAudioFile::setAlbum( std::string str )
{
  return;
}
std::string &MyAudioFile::getYear()
{
  return notpresent;
}
void MyAudioFile::setYear( std::string str )
{
  return;
}
std::string &MyAudioFile::getComment()
{
  return notpresent;
}
void MyAudioFile::setComment( std::string str )
{
  return;
}
unsigned int MyAudioFile::getGenre()
{
  return 255;
}
void MyAudioFile::setGenre( unsigned int g )
{
  return;
}
unsigned int MyAudioFile::getTracknumber()
{
  return 255;
}
void MyAudioFile::setTracknumber( unsigned int g )
{
  return;
}
std::string &MyAudioFile::getFormat()
{
  return empty;
}
unsigned int MyAudioFile::getBitRate()
{
  return 0;
}
unsigned int MyAudioFile::getSampleRate()
{
  return 0;
}
std::string &MyAudioFile::getChannelMode()
{
  return empty;
}
unsigned int MyAudioFile::getID3V1()
{
  return 2;
}
void MyAudioFile::setID3V1( bool yes )
{
  return;
};
unsigned int MyAudioFile::getID3V2()
{
  return 2;
}
void MyAudioFile::setID3V2( bool yes )
{
  return;
};

bool MyAudioFile::updateInfo( std::string file )
{
  _updatemesg = "Not implemented yet!";
  return false;
}
std::string &MyAudioFile::updateMesg()
{
  return empty;
}

//////////////////////////////////:

bool AudioFile::read()
{
  StringManipulation sm(_filename.substr( _filename.length()-4,4 ));
  std::string ext = sm.to_lower();
  std::string dirfile = _directory + "/" + _filename;

// In a later version, a recognision function should be implemented
  if( ext == ".mp3" )
  {
	_audio = new AudioMp3( dirfile );

  } else if( ext == ".wav" )
  {
	_audio = new AudioWav( dirfile );

#if defined(HAVE_OGG_LIB)
  } else if( ext == ".ogg" )
  {
	_audio = new AudioOgg( dirfile );

#endif
  } else {
	_audio = new AudioUnknown( dirfile );
  }

  return valid();
}

void AudioFile::setChangable( bool ID3OK )
{
  if( !ID3OK || (getTitle() == notpresent) )
    ui_lineedit_title->setEnabled( false );
  else 
    ui_lineedit_title->setEnabled( true );

  if( !ID3OK || (getArtist() == notpresent) )
    ui_lineedit_artist->setEnabled( false );
  else
    ui_lineedit_artist->setEnabled( true );

  if( !ID3OK || (getAlbum() == notpresent) )
    ui_lineedit_album->setEnabled( false );
  else
    ui_lineedit_album->setEnabled( true );

  if( !ID3OK || (getYear() == notpresent) )
    ui_lineedit_year->setEnabled( false );
  else
    ui_lineedit_year->setEnabled( true );

  if( !ID3OK || (getComment() == notpresent) )
    ui_lineedit_comment->setEnabled( false );
  else
    ui_lineedit_comment->setEnabled( true );

  if( !ID3OK || (getGenre() == 255) )
    ui_combobox_genre->setEnabled( false );
  else
    ui_combobox_genre->setEnabled( true );

  if( !ID3OK || (getTracknumber() == 255) )
    ui_spinbox_track->setEnabled( false );
  else
    ui_spinbox_track->setEnabled( true );
}

void AudioFile::setProperty()
{
  if( ! _read  )
  {
	read();
	_read = true;
  }

  AudioGenre genre;
  for( unsigned int i = 0; i <= genre.max(); i++ )
  {
	ui_combobox_genre->insertItem( tr( genre.getGenreNameIdx( i ) ) );
  }
  std::string dirfile = _directory + "/" + _filename;
  ui_textlabel_directory->setText( _directory.c_str() );
  ui_textlabel_filename->setText( _filename.c_str() );

  std::strstream str;

  str << getLength() << " secs" << std::ends;
  ui_textlabel_playlength->setText( sec2hour(getLength()).c_str() );

  ui_textlabel_format->setText( getFormat().c_str() );

  str.seekp( 0, std::ios::beg );
  str << getBitRate() << " kBytes" << std::ends;
  ui_textlabel_bitrate->setText( str.str() );

  str.seekp( 0, std::ios::beg );
  str << getSampleRate() << " HZ" << std::ends;
  ui_textlabel_samplerate->setText( str.str() );
  ui_textlabel_mode->setText( getChannelMode().c_str() );

  QFile f( dirfile.c_str() );
  str.seekp( 0, std::ios::beg );
  str << f.size() << std::ends;
  std::string s;
  s = str.str();
  s = StringManipulation::insertDelimiter(s, ',', 3 );
  s.append( " Bytes" );
  ui_textlabel_size->setText( s.c_str() );

  setChangable( true );

  if( getID3V1() > 1 )
    ui_checkbox_id3v1->setEnabled( false );
  else
    ui_checkbox_id3v1->setChecked( getID3V1() == 1 );

  if( getID3V2() > 1 )
    ui_checkbox_id3v2->setEnabled( false );
  else
    ui_checkbox_id3v2->setChecked( getID3V2() == 1 );

  ui_lineedit_title->setText( getTitle().c_str() );
  ui_lineedit_artist->setText( getArtist().c_str() );
  ui_lineedit_album->setText( getAlbum().c_str() );
  ui_lineedit_year->setText( getYear().c_str() );
  ui_lineedit_comment->setText( getComment().c_str() );

  if( getGenre() != 255 )
  {
    AudioGenre genre;
    ui_combobox_genre->setCurrentItem( genre.findGenreIdx(getGenre()) );
  }

  if( getTracknumber() != 255 )
    ui_spinbox_track->setValue( getTracknumber() );
}

std::string AudioFile::sec2hour( unsigned int secs )
{
  std::strstream str;
  unsigned h = secs / 3600;
  unsigned m = (secs - h*3600) / 60;
  unsigned s = secs - h*3600 - m*60;

  str.fill('0');
  str << std::setw(2) << h << ":" <<
	 std::setw(2) << m << ":" <<
	 std::setw(2) << s << std::ends;
	
  return str.str();
}

void AudioFile::setFile( const std::string directory,
		         const std::string filename,
		         bool read)
{
  _filename.assign( filename );
  _directory.assign( directory );
  _read = read;

  if( read )
  {
	AudioFile::read();
  } else {
	_audio = new AudioUnknown("");
  }
}

AudioFile::AudioFile( QWidget *parent, const char* name, bool modal, WFlags fl )
	: BAudioFile( parent, name, modal, fl )
{
}

AudioFile::~AudioFile()
{
}

void AudioFile::slotUpdateAudioFile()
{
  AudioGenre genre;
  std::cout << "AudioFile::slotUpdateAudioFile(): entered!" << std::endl;
  if(	ui_lineedit_title->edited() ||
  	ui_lineedit_artist->edited() ||
	ui_lineedit_album->edited() ||
	ui_lineedit_year->edited() ||
	ui_lineedit_comment->edited() ||
	(ui_checkbox_id3v1->isChecked() && getID3V1() == 0) ||
	(!ui_checkbox_id3v1->isChecked() && getID3V1() == 1) ||
	(ui_checkbox_id3v2->isChecked() && getID3V2() == 0) ||
	(!ui_checkbox_id3v2->isChecked() && getID3V2() == 1) ||
	(ui_spinbox_track->text().toUInt() != getTracknumber()) ||
	(ui_combobox_genre->currentItem() != genre.findGenreIdx(getGenre()) )
  )
  {
#ifdef DEBUG
    std::cout << "Values has been edited" << std::endl;
#endif

    setTitle( std::string( ui_lineedit_title->text().latin1() ) );
    setArtist( std::string( ui_lineedit_artist->text().latin1() ) );
    setAlbum( std::string( ui_lineedit_album->text().latin1() ) );
    setYear( std::string( ui_lineedit_year->text().latin1() ) );
    setComment( std::string( ui_lineedit_comment->text().latin1() ) );
    setTracknumber( ui_spinbox_track->text().toUInt() );
    setGenre( genre.getGenreNum(ui_combobox_genre->currentItem()) );
    setID3V1( ui_checkbox_id3v1->isChecked() );
    setID3V2( ui_checkbox_id3v2->isChecked() );

    if( ! updateInfo( _directory + _filename ) )
    {
      std::cout << "Update messges: " << updateMesg() << std::endl;
      QMessageBox::warning( this, tr("Update AudioFile Information"),
	tr("<qt>"
	   "<center><b>Updating audio information of file:</b></center><br/>"
	   "<pre>%1%2</pre><br/>"
	   "failed. Error was:<br/>"
	   "<center><b>%3</b></center>"
	   "</qt>")
		.arg( QString(getDirectory().c_str()) )
		.arg( QString(getFilename().c_str()) )
		.arg( QString( updateMesg().c_str()) ),
		QMessageBox::Ok, 0 );
    }
#ifdef DEBUG
  } else {
    std::cout << "No changes has been made!" << std::endl;
#endif
  }

  emit close();
}

void AudioFile::slotID3Checkbox( int state )
{
#ifdef DEBUG
  std::cout << "AudioFile::slotID3Checkbox() entered." << std::endl;
  std::cout << "State=" << state << std::endl;
#endif

  setChangable( ui_checkbox_id3v1->isChecked() || (state == 2)
	     || ui_checkbox_id3v2->isChecked() );
}
