/*
 */
#include "AudioGenre.h"

#include <string>

struct genre_list_type
{
  const char 		*name;
  const unsigned int	num;
};

static struct genre_list_type genrelist[] = {
	{ "A Cappella",	 123 },
	{ "Acid Jazz",	 74 },
	{ "Acid Punk",	 73 },
	{ "Acid",	 34 },
	{ "Acoustic",	 99 },
	{ "AlternRock",	 40 },
	{ "Alternative", 20 },
	{ "Ambient",	 26 },
	{ "Anime",	 145 },
	{ "Avantgarde",	 90 },
	{ "Ballad",	 116 },
	{ "Bass",	 41 },
	{ "Beat",	 135 },
	{ "Bebob",	 85 },
	{ "Big Band",	 96 },
	{ "Black Metal",	 138 },
	{ "Bluegrass",	 89 },
	{ "Blues",	 0 },
	{ "Booty Bass",	 107 },
	{ "BritPop",	 132 },
	{ "Cabaret",	 65 },
	{ "Celtic",	 88 },
	{ "Chamber Music",	 104 },
	{ "Chanson",	 102 },
	{ "Chistian Rap",61 },
	{ "Chorus",	 97 },
	{ "Christian Gangsta Rap",	 136 },
	{ "Christian Rock",	 141 },
	{ "Classic Rock",1 },
	{ "Classical",	 32 },
	{ "Club",	 112 },
	{ "Club-House",	 128 },
	{ "Comedy",	 57 },
	{ "Contemporary Christian",	 140 },
	{ "Country",	 2 },
	{ "Crossover",	 139 },
	{ "Cult",	 58 },
	{ "Dance Hall",	 125 },
	{ "Dance",	 3 },
	{ "Darkwave",	 50 },
	{ "Death Metal", 22 },
	{ "Disco",	 4 },
	{ "Dream",	 55 },
	{ "Drum & Bass",	 127 },
	{ "Drum Solo",	 122 },
	{ "Duet",	 120 },
	{ "Easy Listening",	 98 },
	{ "Electronic",	 52 },
	{ "Ethnic",	 48 },
	{ "Euro-House",	 124 },
	{ "Euro-Techno", 25 },
	{ "Eurodance",	 54 },
	{ "Fast-Fusion", 84 },
	{ "Folk",	 80 },
	{ "Folk/Rock",	 81 },
	{ "Folklore",	 115 },
	{ "Freestyle",	 119 },
	{ "Funk",	 5 },
	{ "Fusion",	 30 },
	{ "Game",	 36 },
	{ "Gangsta",	 59 },
	{ "Goa",	 126 },
	{ "Gospel",	 38 },
	{ "Gothic Rock", 91 },
	{ "Gothic",	 49 },
	{ "Grunge",	 6 },
	{ "Hard Rock",	 79 },
	{ "Hardcore",	 129 },
	{ "Heavy Metal",	 137 },
	{ "Hip-Hop",	 7 },
	{ "House",	 35 },
	{ "Humour",	 100 },
	{ "Indie",	 131 },
	{ "Industrial",	 19 },
	{ "Instrumental Pop", 46 },
	{ "Instrumental Rock", 47 },
	{ "Instrumental",33 },
	{ "JPop",	 146 },
	{ "Jazz",	 8 },
	{ "Jazz+Funk",	 29 },
	{ "Jungle",	 63 },
	{ "Latin",	 86 },
	{ "Lo-Fi",	 71 },
	{ "Meditative",	 45 },
	{ "Merengue",	 142 },
	{ "Metal",	 9 },
	{ "Musical",	 77 },
	{ "National Folk",	 82 },
	{ "Native American",	 64 },
	{ "Negerpunk",	 133 },
	{ "New Age",	 10 },
	{ "New Wave",	 66 },
	{ "Noise",	 39 },
	{ "Oldies",	 11 },
	{ "Opera",	 103 },
	{ "Other",	 12 },
	{ "Polka",	 75 },
	{ "Polsk Punk",	 134 },
	{ "Pop",	 13 },
	{ "Pop-Folk",	 53 },
	{ "Pop/Funk",	 62 },
	{ "Porn Groove",	 109 },
	{ "Power Ballad",	 117 },
	{ "Pranks",	 23 },
	{ "Primus",	 108 },
	{ "Progressive Rock",	 92 },
	{ "Psychadelic", 67 },
	{ "Psychedelic Rock",	 93 },
	{ "Punk Rock",	 121 },
	{ "Punk",	 43 },
	{ "R&B",	 14 },
	{ "Raggae",	 16 },
	{ "Rap",	 15 },
	{ "Rave",	 68 },
	{ "Retro",	 76 },
	{ "Revival",	 87 },
	{ "Rhythmic Soul",	 118 },
	{ "Rock & Roll", 78 },
	{ "Rock",	 17 },
	{ "Salsa",	 143 },
	{ "Samba",	 114 },
	{ "Satire",	 110 },
	{ "Showtunes",	 69 },
	{ "Ska",	 21 },
	{ "Slow Jam",	 111 },
	{ "Slow Rock",	 95 },
	{ "Sonata",	 105 },
	{ "Soul",	 42 },
	{ "Sound Clip",	 37 },
	{ "Soundtrack",	 24 },
	{ "Southern Rock",	 56 },
	{ "Space",	 44 },
	{ "Speech",	 101 },
	{ "Swing",	 83 },
	{ "Symphonic Rock",	 94 },
	{ "Symphony",	 106 },
	{ "Synthpop",	 147 },
	{ "Tango",	 113 },
	{ "Techno",	 18 },
	{ "Techno-Industrial", 51 },
	{ "Terror",	 130 },
	{ "Thrash Metal",	 144 },
	{ "Top 40",	 60 },
	{ "Trailer",	 70 },
	{ "Trance",	 31 },
	{ "Tribal",	 72 },
	{ "Trip-Hop",	 27 },
	{ "Vocal",	 28 },
	{ "Unknown",	 148 },
};

#define MAX_GENRE	(sizeof( genrelist ) / sizeof( struct genre_list_type ))

// getGenreNum: returns the genre number of a given idx
unsigned int AudioGenre::getGenreNum( unsigned int idx )
{
   if( idx > MAX_GENRE )
	return( genrelist[max()].num );

   return( genrelist[idx].num );
}

// getGenreNameIdx: return the name of the given idx as offset
const char *AudioGenre::getGenreNameIdx( unsigned int idx )
{
    if( idx > MAX_GENRE )
	return( genrelist[max()].name );

    return( genrelist[idx].name );
}

// findGenreNum: returns the offset in table of a given genre number
unsigned int AudioGenre::findGenreNum( unsigned int idx )
{
    for( int i = 0; i < MAX_GENRE; i++ )
    {
	if( idx == genrelist[i].num )
	    return genrelist[i].num;
    }
    return max();
}

// findGenreNum: returns the genre number of a given string
unsigned int AudioGenre::findGenreNum( const char *string )
{
    for( int i = 0; i < MAX_GENRE; i++ )
    {
	if( strcasecmp(string, genrelist[i].name) == 0 )
	    return genrelist[i].num;
    }
    return max();
}

// findGenreIdx: returns the offset of a given genre number
unsigned int AudioGenre::findGenreIdx( unsigned int num )
{
    for( unsigned int i = 0; i < MAX_GENRE; i++ )
    {
	if( num == genrelist[i].num )
	    return i;
    }
    return max();
}

unsigned int AudioGenre::max()
{
    return MAX_GENRE -1;
}

