/*!
    $Author: etzi $
    $Revision: 1.4 $
    $Date: 2002/07/28 11:47:50 $
*/    

#include "AudioWav.h"
#include "RiffFile.h"

#include <iostream>
#include <strstream>
#include <fstream>

unsigned short formatType;
unsigned short numChannels;
unsigned long sampleRate;
unsigned long bytesPerSec;
unsigned short bytesPerSample;
unsigned short bitsPerChannel;
unsigned long dataLength;

///////////////////////////////////////////////////////////
//          AudioWav Class starts here
///////////////////////////////////////////////////////////
AudioWav::AudioWav( std::string filename )
{
  _length = 0;
  RiffFile readFile( filename.c_str() );

  if( strcmp(readFile.chunkName(), "RIFF")
	|| strcmp(readFile.subType(), "WAVE")
	|| !readFile.push("fmt ") )
  {
    std::cout << "No RIFF, WAVE or fmt" << std::endl;
  } else {
    unsigned int dwFmtSize = readFile.chunkSize();
    char * fmtChunk = new char[dwFmtSize];

    if( readFile.filep()->read(fmtChunk, dwFmtSize ) )
    {
	readFile.pop();
	formatType = *((short*) fmtChunk);
	numChannels = *((short*) (fmtChunk + 2));
	sampleRate = *((long*) (fmtChunk + 4));
	bytesPerSec = *((long*) (fmtChunk + 8));
	bytesPerSample = *((short*) (fmtChunk + 12));
	bitsPerChannel = *((short*) (fmtChunk + 14));
	if( readFile.push("data") )
	{
	  if( bytesPerSec )
	  {
	    _length = readFile.chunkSize() / bytesPerSec;
	  }
	  _bitrate = bytesPerSec * 8 / 1000; // Why 1000 and not 1024?
	  _samplerate = sampleRate;
	  _valid = true;
	  switch( numChannels ) {
	    case 1:	_channelmode = std::string("mono");
			break;
	    case 2:	_channelmode = std::string("stereo");
			break;
	    default:	std::strstream str;
			str << numChannels << " channels" << std::ends;
			_channelmode = str.str();
			break;
	  }
	  switch( formatType ) {
	    case 0x01:  _format = std::string("Microsoft PCM");
			break;
	    case 0x0101:_format = std::string("IBM mu-law");
			break;
	    case 0x0102:_format = std::string("IBM a-law");
			break;
	    case 0x0103:_format = std::string("IBM AVC ADPCM");
			break;
	    case 0x02: _format = std::string("Microsoft ADPCM");
			break;
	    default:	_format = std::string("PCM (unknown)");
			std::cout << "Format Type: " << formatType <<
				" unknown" << std::endl;
	  }
	}
	readFile.rewind();
	int type;
	std::string value;
	readFile.push( "LIST") ;
	while( readFile.getNextExtraItem( &type, value ) )
	{
//	  std::cout << "Type: " << type << " Value: " << value << std::endl;
	  switch( type ) {
	    case 0:	_title = value;
			break;
	    case 2:	_artist = value;
			break;
	    case 15:	if( _title.empty() ) _title = value;
			break;
	    default:	break;
	  }
	}
     }
//     readFile.filep().close( );
  }
}

bool AudioWav::updateInfo( std::string filename )
{
  _updatemesg = "Not implemented yet riff wave files!";
  return false;
}

