#include "Gnutella.h"
#include "Bye.h"
#include "Message.h"

Bye::Bye( const std::string& payload )
{
  _code = Message::str_uint16( payload.substr(0, 2).c_str() );
  _message = payload.substr(2);

  std::string s[] = { std::string("\0", 1), std::string("\r\n\r\n") };

  // remove all \0 and \r\n\r\n
  for(int i = 0; i < 2; ++i)
    while( _message.find( s[i] ) != std::string::npos )
      {
	std::string::size_type idx;
	idx = _message.find( s[i] );
	_message.replace( idx, s[i].size(), "" );
      }

  // replace all \r\n by " "
  while( _message.find( "\r\n" ) != std::string::npos )
    {
      std::string::size_type idx;
      idx = _message.find( "\r\n" );
      _message.replace( idx, 2, " / " );
    }
}

Bye::Bye( const int code)
{
  _code = code;
  
  std::string servent = std::string("Server: Qtella ") + std::string(VERSION) 
	+ std::string( ADDITIONAL_VERSION_STR ) + "\r\n\r\n";

  switch( code )
    {
    case 200:
      _message = "Shutting down\r\n";
      break;
    case 201:
      _message = "Explicit close\r\n";
      break;
    case 501:
      _message = "Protocol desynchronization\r\n";
      break;
    default:
      _message = "Unknown status\r\n";
    }

  _message += servent;
}

Bye::~Bye()
{
}

const void Bye::setMessage( const std::string& message, const int code )
{
  _message = message;
  _code = code;
}

const std::string Bye::toString()
{
  std::string s;
  s = "0000000000000000";              // gnode identifier
  s += std::string( "\2\1\0", 3 );     // function, ttl, hops

  Q_UINT32 payload_length = _message.size() + 2;

  s += Message::uint_str( payload_length );  // payload length

  s += Message::uint_str( _code );  // payload
  s += _message;

  return s;
}
