#include "Connections.h"
#include "GWebCacheManager.h"
#include "SearchParameters.h"
#include "SearchPersistence.h"

#include "Pong.h"
#include "Ping.h"
#include "Query.h"
#include "Bye.h"
#include "Push.h"
#include "QueryHit.h"

#include "QtellaSub.h"
#include "Servent.h"
#include "Host.h"
#include "QueryHitEntry.h"
#include "SearchWidget.h"
#include "Search.h"
#include "SharedFile.h"
#include "QueryResult.h"
#include "Message.h"
#include "UploadManager.h"
#include "StringManipulation.h"
#include "SearchViewItem.h"
#include "PongCache.h"
#include "SearchSharedFiles.h"
#include "InterruptedDownloads.h"
#include "Logging.h"
#include "PongCache.h"
#include "WidgetConnections.h"
#include "WidgetSearch.h"
#include "WidgetConfig.h"
#include "WidgetStats.h"
#include "WidgetLogs.h"

#include "Gnutella.h"

#include <iostream>
#include <map>
#include <list>
#include <algorithm>
#include <memory>
#include <strstream>
#include <iomanip>

#include <cstdlib>
#include <ctime>
#include <cctype>   // tolower

#include <qevent.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qcolor.h>
#include <qsocket.h>
#include <qtabwidget.h>
#include <qmessagebox.h>
#include <qobject.h>
#include <qstatusbar.h>

#ifdef DEBUG
#include <qfile.h>
#endif

#undef COUT_OUTPUT
#undef _DEBUG

Connections* Connections::_this = NULL;
int Connections::GREEN = 0;
int Connections::GRAY = 1;
int Connections::YELLOW = 2;
int Connections::RED = 3;

Connections::Connections(QtellaSub* parent)
  : _parent(parent), _address(), _statistic(), _max_hosts(300), _timer(NULL),
    _blocked_packets(0), _all_packets(0), _ignored_packets(0)
{
  _this = this;

  _address.setPort(parent->_current_port);
  _max_servants = _parent->_widget_connections->ui_spinbox_hosts->value();

  _id = createID();

  _statistic_timer = new QTimer();
  connect(_statistic_timer, SIGNAL(timeout()), this, SLOT(slotUpdateStatistic()));
  _statistic_timer->start(1000);

  _uptime = new QDateTime( QDate::currentDate(), QTime::currentTime() );

  _timer = new QTimer(this);
  connect(_timer, SIGNAL(timeout()), SLOT(check()));
  _timer->start(500);

  connect(&_resubmitQueriesTimer, SIGNAL(timeout()), this, SLOT(slotResubmitQueries()));
  _resubmitQueriesTimer.start(600 * 1000);

#if defined(_WIN32)
  // windows has problems with a large number of pixmaps
  // see QPixmap description for more details
  QPixmap::setDefaultOptimization( QPixmap::MemoryOptim );
#endif

  // create the pixmaps for the speed bar in the search tab for all
  // possible speeds and colors
  // this will speed up the creation of the search result list a bit
  for( int i = 0; i < 63; ++i )
    for( int c = 0; c < 4; ++c )
      {
	QImage img(64, 11, 32, 16);
	img.fill(qRgb(0xff, 0xff, 0xff));
	int x;
	int y;
	for(x = 0; x < 64; x++)
	  {
	    img.setPixel(x, 0, qRgb(0xaa, 0xaa, 0xaa));
	    img.setPixel(x, 10, qRgb(0xaa, 0xaa, 0xaa));
	  }
	for(y = 0; y < 11; y++)
	  {
	    img.setPixel(0, y, qRgb(0xaa, 0xaa, 0xaa));
	    img.setPixel(63, y, qRgb(0xaa, 0xaa, 0xaa));
	  }
	QPixmap pict;
	
	QColor color(0x60, 0x60, 0x60);

	if( c == RED )
	  color = QColor(0xB0, 0x30, 0x30);
	else
	  if( c == GREEN )
	    color = QColor(0x30, 0xB0, 0x30);
	  else
	    if( c == YELLOW )
	      color = QColor(0xB0,0xB0,0x30);

	for(y = 1; y <= 9; ++y)
	  for(x = 1; x <= i; ++x) img.setPixel(x, y, color.rgb());
	
	_speed_bar[i][c].convertFromImage(img);
      }
  srand(time(NULL));
}


std::string Connections::createID()
{
  #ifdef QTELLA_DEBUG
    std::clog << "Connections: create ID" << std::endl;
  #endif

  std::string id;

  for(int i = 0; i < 16; i++)
    {
      unsigned char c = rand()%255;
      id += c;
    }

   id[8] = (char)(0xff);
   id[15] = (char)(1);

  return id;
}


Connections::~Connections()
{
  #ifdef QTELLA_DEBUG
    std::clog << "Connections: destructor" << std::endl;
  #endif

  delete _statistic_timer;
  delete _uptime;
  if(_timer) delete _timer;
}


void Connections::disconnect()
{
#ifdef QTELLA_DEBUG
  std::clog << "Connections: disconnect" << std::endl;
#endif

  for(int i = 0; i < _servants.size(); ++i) 
    {
      _servants[i]->setByeCode(200);
      delete _servants[i];
    }
  _servants.clear();  
}


void Connections::start()
{
  try {

  int          reserved_in = _parent->_widget_connections->ui_spinbox_inconnects->value(); //in
  int          max_out = _max_servants; //out
  int          out_connected = 0;
  int          out_tmp = 0;
  int          in_connected = 0;
  int          connecting = 0;

  for(int j = 0; j < _servants.size(); ++j)
    {
      if((_servants[j]->state() == Servent::Connected))
	{
	  if( (_servants[j]->uptime() > 7) && (_servants[j]->getDirection() == Servent::Outgoing) ) ++out_connected;
	  else
	    if( _servants[j]->getDirection() == Servent::Outgoing ) ++out_tmp;
	  if(_servants[j]->getDirection() == Servent::Incoming)	++in_connected;
	}
      if( (_servants[j]->state() == Servent::Connecting) || (_servants[j]->state() == Servent::Waiting) )
	++connecting;
    }

  while( in_connected > _parent->_widget_connections->ui_spinbox_inconnects->value() )
    for(int j = _servants.size(); j > 0; --j)
      if( (_servants[j-1]->uptime() > 7) && (_servants[j-1]->getDirection() == Servent::Incoming) )
        {
          _servants[j-1]->setByeCode(201);
          delete _servants[j-1];
          _servants.erase(std::find(_servants.begin(), _servants.end(), _servants[j-1]));
          --in_connected;
          break;
        }

  if(out_connected > max_out)
    {
      while(out_connected > max_out)
	for(int j = _servants.size(); j > 0; --j)
	  if((_servants[j-1]->uptime() > 7) && (_servants[j-1]->getDirection() == Servent::Outgoing))
	    {
	      _servants[j-1]->setByeCode(201);
	      delete _servants[j-1];
	      _servants.erase(std::find(_servants.begin(), _servants.end(), _servants[j-1]));
	      --out_connected;
	      break;
	    }

      std::vector<Servent*>::iterator pos = _servants.begin();
      
      while(pos != _servants.end())
	if( (((*pos)->uptime() <= 7) && ((*pos)->getDirection() == Servent::Outgoing)) ||
	    ((*pos)->state() == Servent::Connecting) || ((*pos)->state() == Servent::Waiting) )
	  {
	    if(((*pos)->state() == Servent::Connecting) || ((*pos)->state() == Servent::Waiting) )
	      --connecting;
	    else
	      --out_tmp;
	    (*pos)->setByeCode(201);
	    delete *pos;
	    pos = _servants.erase(pos);
	  }
	else ++pos;

      return;
    }
      
  int delta = (max_out - out_connected) << 2;

  while( (out_tmp + connecting) < delta )
    {
      while( (_parent->_widget_connections->ui_listbox_hostlist->count() > 0) && ((out_tmp+connecting) < delta) )
        {
          std::string  s = _parent->_widget_connections->ui_listbox_hostlist->text(0).latin1();
          bool         ignore = false;
          
          _parent->_widget_connections->ui_listbox_hostlist->removeItem(0);
          for(int j = 0; j < _servants.size(); ++j) 
            //if( s == std::string(_servants[j]->_item->text(0))) ignore = true;
            if( s == _servants[j]->_address.toString() )
              ignore = true;
          if(!ignore) 
            {
              addServant(Address(s));
              ++out_tmp;
            }
        }
      
      int i = 0;
      while( (i < _parent->_widget_connections->ui_listbox_autoconnect->count()) && ((out_tmp+connecting) < delta) )
        {
          bool ignore = false;
          std::string s = _parent->_widget_connections->ui_listbox_autoconnect->text(i).latin1();
          for(int j = 0; j < _servants.size(); ++j) 
            //if( s == std::string(_servants[j]->_item->text(0))) 
            if( s == _servants[j]->_address.toString() )
              ignore = true;
          if(!ignore) 
            {
              addServant(Address(s));
              ++out_tmp;
            }
          ++i;
        }

			if(_parent->_widget_connections->ui_listbox_hostlist->count() == 0) 
				{
					_parent->_gWebCache->requestHosts();
					break;
				}
    }
  
  }catch(...) { std::cerr << "EXCEPTION" << std::endl; }
}


void Connections::addServant(Address address, QSocket* socket, const std::string& user_agent, 
                             const std::string& handshake)
{
  // if socket != NULL than it is an incoming connection

  try
    {
      QListViewItem *item = NULL;

      // count the number of incoming and outgoing connections
      // a connection is established when it is up for at least seven seconds
      int          out_connected = 0;
      int          in_connected = 0;
      for(int j = 0; j < _servants.size(); ++j)
        if( (_servants[j]->state() == Servent::Connected) )
          if( (_servants[j]->uptime() > 7) && 
              (_servants[j]->getDirection() == Servent::Outgoing) ) 
            ++out_connected;
          else 
            if(_servants[j]->getDirection() == Servent::Incoming) ++in_connected;

      std::string group = Servent::getHeaderField( handshake, "X-Qtella-Group" );
      std::string user = Servent::getHeaderField( handshake, "X-Qtella-User" );

      //std::cout << "user: " << user << std::endl << "group: " << group << std::endl;

      // check whether 
      if( socket && (in_connected >= _parent->_widget_connections->ui_spinbox_inconnects->value()) )
        {
          std::list<Pong>               ponglist;
          PongCache::getInstance()->getPong(ponglist, 10);
          std::list<Pong>::iterator     pos = ponglist.begin();
          
          std::string s = "GNUTELLA/0.6 503 BUSY\r\n";
          s += "User-Agent: Qtella " + std::string(VERSION) + ADDITIONAL_VERSION_STR + "\r\n";
          s += "X-Try: ";
          
          while( pos != ponglist.end() )
            {
              s += (*pos)._address.toString();
              ++pos;
              if( pos != ponglist.end() ) s += ",";
            }
          
          s += "\r\n\r\n";
          
#ifdef _DEBUG
          qDebug( "Connections: incoming busy" );
          qDebug( "Connections: send: <%s>", s.c_str() );
#endif
          socket->writeBlock( s.data(), s.size() );
          socket->flush();
          closeSocket( socket );
          return;
        }
      
      if( (!socket) && (out_connected >= _parent->_widget_connections->ui_spinbox_hosts->value()) )
        {
          if(socket) delete socket;
          return;
        }
      
      if( ( ! _parent->_widget_connections->ui_checkbox_showestablished->isChecked() ) || socket )
        {
          if(_servants.empty())
            item = new QListViewItem(_parent->_widget_connections->ui_listview_connections);
          else
            item = new QListViewItem(_parent->_widget_connections->ui_listview_connections, _servants.back()->_item);
          
          // set address
          item->setText(0, address.toString().c_str());
        }
      
      _servants.push_back(new Servent(this, _id, item, socket, user_agent, handshake));
      
      if(socket) 
        {
          item->setText(1, QObject::tr("Incoming") ); 
          _servants.back()->setDirection(Servent::Incoming);
        }
      else 
        {
          if( item )
            item->setText(1, QObject::tr("Connecting...") );
          
          _servants.back()->setDirection(Servent::Outgoing);
          _servants.back()->connect(address);
        }  
      
      if(!_parent->timer_connection->isActive()) _parent->timer_connection->start(500);
      
    }
  catch(...) 
    { 
      std::cerr << "EXCEPTION" << std::endl; 
    }
}


void Connections::checkServants()
{
#ifdef QTELLA_DEBUG
  std::clog << "Connections: check " << _servants.size() << std::endl;
#endif

#ifdef _DEBUG
  qDebug("entering Connections::checkServants");
#endif

  closeSocket(NULL);

  unsigned long hosts = 0;

  double bandwidth_in = 0;
  double bandwidth_out = 0;

  try{

  for( int i = 0; i < _servants.size(); ++i)
    switch( _servants[i]->state() )
      {
      case Servent::Connected:
	{
#ifdef QTELLA_DEBUG
	  std::clog << "Connections: switch " << i << std::endl;
#endif
	  if( ! _servants[i]->_item )
	    {
	      if(_servants.empty())
          _servants[i]->_item = new QListViewItem(_parent->_widget_connections->ui_listview_connections);
	      else
          _servants[i]->_item = new QListViewItem(_parent->_widget_connections->ui_listview_connections, _servants.back()->_item);
	      
	      // set address
	      _servants[i]->_item->setText(0, _servants[i]->_address.toString().c_str());
	    }
	  
	  if(_servants[i]->getDirection() == Servent::Outgoing)
	    _servants[i]->_item->setText(1, QObject::tr("Outgoing") );
	  else
	    _servants[i]->_item->setText(1, QObject::tr("Incoming") );

	  _servants[i]->limitVectors();

	  std::strstream str;
	  str << _servants[i]->_input << " / " << _servants[i]->_output << std::ends;
	  _servants[i]->_item->setText(2, str.str());
	  str.freeze(false);

	  // number of hosts (in list)
	  unsigned sh = PongCache::getInstance()->getHosts(_servants[i]->_servant_number);
	  hosts += sh;
	  str.seekp(0, std::ios::beg);
	  str << sh << std::ends;
	  _servants[i]->_item->setText(3, str.str());
	  str.freeze(false);

	  // bandwidth
	  str.seekp(0, std::ios::beg);
	  str.setf(std::ios::fixed);
	  str << std::setprecision(2) << _servants[i]->_bandwidth_in << " / " 
	      << _servants[i]->_bandwidth_out << std::ends;

	  _servants[i]->_item->setText(4, str.str());
	  str.freeze(false);

	  bandwidth_in += _servants[i]->_bandwidth_in;
	  bandwidth_out += _servants[i]->_bandwidth_out;

	  // uptime
	  unsigned u = time(NULL) - _servants[i]->_start;
	  unsigned h = u / 3600;
	  unsigned m = (u - h * 3600) / 60;
	  unsigned s = u - h * 3600 - m * 60;
	  std::strstream uptime;
	  uptime.fill('0');
	  uptime << std::setw(2) << h << ":" << std::setw(2) << m << ":" << std::setw(2) << s << std::ends;
	  _servants[i]->_item->setText(5, uptime.str());
	  uptime.freeze(false);

	  // display protocol version
	  _servants[i]->_item->setText(6, _servants[i]->_version.c_str());

	  // display user agent
	  _servants[i]->_item->setText(7, _servants[i]->_user_agent.c_str());
	}
	break;

      case Servent::Closed:
        if( _servants[i]->_item )
          {
            _servants[i]->_item->setText(1, QObject::tr("Closed") );
            if( _parent->_widget_connections->ui_checkbox_showestablished->isChecked() )
              {
                delete _servants[i]->_item;
                _servants[i]->_item = NULL;
              }
          }
        break;

      case Servent::Closing:
		if( _servants[i]->_item )
		  {
        _servants[i]->_item->setText(1, QObject::tr("Closing", "displayed int connections") );
        if( _parent->_widget_connections->ui_checkbox_showestablished->isChecked() )
          {
            delete _servants[i]->_item;
            _servants[i]->_item = NULL;
          }
		  }
		_servants[i]->setState(Servent::Closed);
		break;

      case Servent::Connecting:
		{
		  if( _servants[i]->_item )
			{
			  std::strstream str;
			  str << QObject::tr("Connecting...", "connecting to a servent") 
				  << " (" << (10 - _servants[i]->_timeout) << ")" << std::ends;
			  _servants[i]->_item->setText(1, str.str());
			  str.freeze(false);
			  
			  if( _parent->_widget_connections->ui_checkbox_showestablished->isChecked() )
				{
				  delete _servants[i]->_item;
				  _servants[i]->_item = NULL;
				}
			}
		}
	  break;
	  
      case Servent::Error:
		if( _servants[i]->_item )
		  {
			_servants[i]->_item->setText(1, QObject::tr("Error") );
			if( _parent->_widget_connections->ui_checkbox_showestablished->isChecked() )
			  {
				delete _servants[i]->_item;
				_servants[i]->_item = NULL;
			  }
		  }
		break;
		
      case Servent::Waiting:
		if( _servants[i]->_item )
		  {
			_servants[i]->_item->setText(1, QObject::tr("Waiting") );
			if( _parent->_widget_connections->ui_checkbox_showestablished->isChecked() )
			  {
				delete _servants[i]->_item;
				_servants[i]->_item = NULL;
			  }
		  }
		break;
		
      default:
		if( _servants[i]->_item )
		  _servants[i]->_item->setText(1, QObject::tr("Unknown", "state of connection is unknown") );
		break;
      }

  } catch(...) { std::cerr << "EXC Connections::checkServant A" << std::endl; }
  

  try{

  // delete servent which are in close or error state and increase timeout counter of all servents
  std::vector<class Servent*>::iterator    pos;

  #ifdef QTELLA_DEBUG
    std::clog << "Connections: check close and error" << std::endl;
  #endif

  // timeout = 7.5 sec because DNS lookup signal caused SEGV
  for(pos = _servants.begin(); pos != _servants.end(); )
    if( ( (*pos)->state() == Servent::Closed ) || 
	( (*pos)->state() == Servent::Error  && (*pos)->_timeout++ > 4) || 
	( (*pos)->_timeout++ > 10 && (*pos)->state() != Servent::Connected) )
      {
	if( (*pos)->_item )
	  (*pos)->_item->setSelected(false);
	delete *pos;
	pos = _servants.erase(pos);
      }
    else ++pos;
  
  } catch(...) { std::cerr << "EXC Connections::checkServant B" << std::endl; }

  // connect to other hosts
  start();

  // number of hosts

  unsigned long files = 0;
  unsigned long size  = 0;

  std::list< std::pair< time_t, std::pair< unsigned long, unsigned long > > >::iterator p;
  
  for( p = _buffer.begin(); p != _buffer.end(); ++p )
    {
      files += p->second.first;
      size += p->second.second;
    }

	std::strstream statusbar;
	statusbar << "Hosts: " << hosts;

  std::strstream str;
  str << hosts << std::ends;
  _parent->_widget_connections->ui_textlabel_hosts->setText(str.str());
  str.freeze(false);

  std::string u;
  str.seekp(0, std::ios::beg);
  if(files > 1024) { files = files / 1024; u = "K"; };
  if(files > 1024) { files = files / 1024; u = "M"; };
  str << files << u << std::ends;
  _parent->_widget_connections->ui_textlabel_files->setText(str.str());
  str.freeze(false);
  statusbar << " Files: " << files << u;

  u = "K";
  str.seekp(0, std::ios::beg);
  if(size > 1024) { size = size / 1024; u = "MB"; }
  if(size > 1024) { size = size / 1024; u = "GB"; }
  //if(size > 1024) { size = size >> 10; u = "TB"; }
  str << size << u << std::ends;
  _parent->_widget_connections->ui_textlabel_size->setText(str.str());
  str.freeze(false);
	statusbar << " Size: " << size << u << std::ends;
	
	QtellaSub::getInstance()->statusBar()->message( statusbar.str() );
	statusbar.freeze( false );

  str.seekp(0, std::ios::beg);
  str.setf(std::ios::fixed);
  str << std::setprecision(1) << bandwidth_in << "KB(In) + " << bandwidth_out << "KB(Out) = " 
      << (bandwidth_in + bandwidth_out) << "KB" << std::ends;
  _parent->_widget_connections->ui_label_connect_bandwidth->setText(str.str());
  str.freeze(false);

#ifdef QTELLA_DEBUG
  std::clog << "Connections: ok checkServants" << std::endl;
#endif

#ifdef _DEBUG
  qDebug("exit Connections::checkServants");
#endif
}


void Connections::check()
{
  for(int i = 0; i < _servants.size(); ++i)
    if( _servants[i]->state() == Servent::Connected ||_servants[i]->state() == Servent::Waiting
	|| _servants[i]->state() == Servent::Closing) 
      checkMessages(_servants[i]);
}


void Connections::checkMessages(Servent* s)
{
#ifdef _DEBUG
  qDebug("entering Connections::checkMessages");
#endif

  try
    {
#ifndef SHARP
      _address.setIP( _parent->_widget_config->ui_lineedit_ip->text().latin1() );
      _address.setPort( _parent->_widget_config->ui_lineedit_listenport->text().latin1() );
#else
      _address.setIP( QtellaSub::getInstance()->getMyAddress() );
      _address.setPort( 6346 );
#endif

      while( ! s->_message_buffer.empty() )
		{
		  Message msg( s->getFirstMessage() );
		  s->removeFirstMessage();

// 		  Message msg( s->_message_buffer.front() );
// 		  s->_message_buffer.pop_front();

		  switch(msg.cmd())
			{
			case CMD_PING:
			  {
#ifdef _DEBUG
				qDebug("ping");
#endif
				std::auto_ptr<Ping>  p(msg.getPing());
				
				_statistic.in_ping_n++;
				_statistic.in_ping_b += p->_data.size();
				
				if( (p->_id == _id) || (p->_ttl < 1) ) break;
				
				s->_last_accepted_ping_id = p->_id;
				
				if( p->_ttl != 1) // host needs pongs
				  {
					std::list<Pong>            pong_list;
					std::list<Pong>::iterator  pos;
					
					PongCache::getInstance()->getPong(pong_list, 10);
					
					for(pos = pong_list.begin(); pos != pong_list.end(); ++pos)
					  {
						pos->_id = p->_id;
						s->sendMessage(pos->_data);
						_statistic.out_pong_n++;
						_statistic.out_pong_b += pos->_data.size();
					  }
				  }
				
				unsigned long size = static_cast<unsigned long>(_parent->shared_size/1024);
				Pong          pong(p->_hops, 0, p->_id, _address, _parent->number_shared_files, size);
				
				s->sendMessage(pong._data, false);
				_statistic.out_pong_n++;
				_statistic.out_pong_b += pong._data.size();
				
#ifdef _DEBUG
				qDebug("exit ping");
#endif
			  }
			  break;
      
	    case CMD_PONG:
	      {
#ifdef _DEBUG
		qDebug("pong");
#endif
		std::auto_ptr<Pong> p(msg.getPong());

		if( hostBlocked( p->_address.strIP() ) )
		  {
		    ++_blocked_packets;
		    break;
		  }

		//std::cout << "<pong> " << p->_files << " " << p->_kbytes << std::endl;
		_buffer.push_back( std::make_pair( time(NULL), std::make_pair( p->_files, p->_kbytes ) ) );
		while( ! _buffer.empty() && ( time(NULL) - _buffer.front().first > 300 ) )
		  _buffer.pop_front();

		_statistic.in_pong_n++;
		_statistic.in_pong_b += p->_data.size();

		if( p->_ttl == 0 )
		  break;

		if( ! p->_address.isPrivate() ) 
		  PongCache::getInstance()->addPong(*p, s->_servant_number);
	
		if( !p->_address.isPrivate() || (p->_address.isPrivate() && !_parent->_widget_connections->ui_checkbox_filterip->isChecked()) )
		  {
		    bool found = false;

		    if(_parent->_widget_connections->ui_listbox_hostlist->count() >= _max_hosts) break;

		    for(int i = 0; i < _parent->_widget_connections->ui_listbox_hostlist->count(); ++i)
		      if( _parent->_widget_connections->ui_listbox_hostlist->text(i) == p->_address.toString().c_str() ) 
            {
              found = true;
              break;
            }
		    
		    if(!found) _parent->_widget_connections->ui_listbox_hostlist->insertItem(p->_address.toString().c_str(), -1);
		  }
#ifdef _DEBUG
		qDebug("exit pong");
#endif
	      }
	      break;
	      
	    case CMD_QUERY:
	      {
#ifdef _DEBUG
		qDebug("query");
#endif
		int i;
		std::auto_ptr<Query> q(msg.getQuery());
	    
		PongCache::getInstance()->addHost(msg.id(), msg.hops(), s->_servant_number);

		_statistic.in_query_n++;
		_statistic.in_query_b += q->_data.size();
		
		int p = -1;
		
		for(i = 0; i < _search.size(); i++) if(q->_id == _search[i]->id) p = 0;
		if( (p == 0) || (q->_ttl < 1) ) break;

		++_statistic._n_total_queries;
		if( q->_search.find("urn:sha1:") != std::string::npos)
		  ++_statistic._n_sha1_queries;

		q->_ttl--;
		q->_hops++;
		
		for(i = 0; i < _servants.size(); ++i)
		  if(_servants[i] != s && _servants[i]->state() == Servent::Connected) 
		    {
		      _servants[i]->sendMessage(q->_data);
		      _statistic.out_query_n++;
		      _statistic.out_query_b += q->_data.size();
		    }
		
		s->_id_set.insert( q->_id );
		
		// 10 queries / sec
		if( (s->_queries >= 10) || (q->_search.size() < 3) ) break;

		std::vector<QueryResult>     qr;
		std::vector<int>             index_vector;
		SearchSharedFiles::getInstance()->search(q->_search, index_vector);

		for(i = 0; i < index_vector.size(); ++i)
		  {
		    int k = index_vector[i];
		    SharedFile *sf = _parent->vSharedFiles[k];
		    QString *sha1 = sf->_sha1;
		    
		    qr.push_back(QueryResult(k, sf->size, sf->file, /*info*/"", 
					     sha1 ? std::string(sha1->latin1(), sha1->length()) : ""));
		  }
		
		int speed[] = {56, 64, 128, 350, 1000, 3000};
		
		if(qr.size() > 0)
		  {
		    _address.setPort( _parent->_current_port );

		    QueryHit qh(q->_id, q->_hops, 0, _address,
				speed[_parent->_widget_config->ui_combobox_speed->currentItem()], _id, qr);

		    s->sendMessageDirect( qh.data() );

		    _statistic.out_hit_n++;
		    _statistic.out_hit_b += qh.data().size();
		  }

		if( _parent->_widget_logs->ui_checkbox_incomingsearch->isChecked() )
		  if( (_parent->_widget_logs->ui_checkbox_searches_match->isChecked() && (qr.size() > 0) ) ||
		      ( ! _parent->_widget_logs->ui_checkbox_searches_match->isChecked() )
		      )
		    _parent->_widget_logs->ui_listbox_incomingsearch->insertItem(q->_search.c_str(), 0);
		
		while(_parent->_widget_logs->ui_listbox_incomingsearch->count() > 40)
		  _parent->_widget_logs->ui_listbox_incomingsearch->removeItem(40);
		
#ifdef _DEBUG
		qDebug("exit query");
#endif
	      }
	      break;

	    case CMD_QUERYHIT:
	      {
#ifdef _DEBUG
					qDebug("queryhit");
#endif
					int i;
					std::auto_ptr<QueryHit> q(msg.getQueryHit());
					
					// check whether this is a valid QueryHit message
					if( ! q->isValid() )
						break;
					
					// if messages from this host should be blocked we quit at this
					// position
					if( hostBlocked( q->_address.strIP() ) )
						{
							++_blocked_packets;
							break;
						}
					
					
					// get the number of files within this query hit and size of
					// all files in KB
					unsigned long nfiles = q->_results.size();
					unsigned long size = 0;
					for( i = 0; i < nfiles; ++i )
						{
							size += q->_results[i]._filesize;
							//std::cout << q->_results[i]._filename << " --- " << std::ends;
						}
					size /= 1024;

					_buffer.push_back( std::make_pair( time(NULL), std::make_pair( nfiles, size ) ) );

					// save only the query hits which are not older than 10 minutes
					while( ! _buffer.empty() && ( time(NULL) - _buffer.front().first > 600 ) )
						_buffer.pop_front();

					// check the trailer of the query hit to determine the vendor
					if(q->_trailer.size() > 6)
						{
							std::string vendor = q->_trailer.substr(0, 4);

							if(vendor == "QTEL") _statistic.hits_qtel_n++;
							else if(vendor == "LIME") _statistic.hits_lime_n++;
							else if(vendor == "BEAR") _statistic.hits_bear_n++;
							else if(vendor == "GTKG") _statistic.hits_gtkg_n++;
							else if(vendor == "GNOT") _statistic.hits_gnot_n++;
							else if(vendor == "SNUT") _statistic.hits_snut_n++;
							else if(vendor == "XOLO") _statistic.hits_xolo_n++;
							else if(vendor == "GNUC") _statistic.hits_gnuc_n++;
							else if(vendor == "MRPH") _statistic.hits_mrph_n++;
							else _statistic.hits_othe_n++;
						}

					// add the host to the PongCache
					PongCache::getInstance()->addHost(msg.id(), msg.hops(), s->_servant_number);
		
					// add the host to the host list of the connection tab if and only if
					// the ip is not private or ip is private but private addresses are accecpted
					if( ! q->_address.isPrivate() || 
							( q->_address.isPrivate() && ! _parent->_widget_connections->ui_checkbox_filterip->isChecked() ) )
						{
							bool found = false;
        
							if( _parent->_widget_connections->ui_listbox_hostlist->count() < _max_hosts )
								{
									for(int i = 0; i < _parent->_widget_connections->ui_listbox_hostlist->count(); ++i)
										if( _parent->_widget_connections->ui_listbox_hostlist->text(i) == q->_address.toString().c_str() ) 
											{
												found = true;
												break;
											}
            
									if( ! found ) 
										_parent->_widget_connections->ui_listbox_hostlist->insertItem(q->_address.toString().c_str(), -1);
								}
						}

					// update statistics for query hits
					_statistic.in_hit_n++;
					_statistic.in_hit_b += q->data().size();
		
					// find the position in _search where this query hit belongs to
					int pos = 0;
					for( pos = 0; pos < _search.size(); pos++ )
						if( q->_id == _search[pos]->id )
							break;

					if( pos == _search.size() )
						{
							// this query hit does not belong to any searches the user
							// started, so we have to send it to the connection where
							// the query came from
							if( q->ttl() > 0 )
								{
									int k;
									for(k = 0; k < _servants.size(); k++)
										if( (_servants[k]!=s) && 
												(_servants[k]->state() == Servent::Connected) &&
												(_servants[k]->_id_set.find(q->_id) != _servants[k]->_id_set.end()) )
											{
												_servants[k]->sendMessage(q->data());
												_statistic.out_hit_n++;
												_statistic.out_hit_b += q->data().size();
											}
								}
							break;
						}

					// pos is the index of _search for this query hit
					int n;
					int t;
		
					// check whether the search has been stopped by the user
					if( ! _search[pos]->active )
						break;

					// compare the speed of the host with the settings in the configuration
					if( q->_speed < _search[pos]->_min_speed )
						break;

					// for each file in the query hit...
					for( n = 0;  n < q->_results.size(); n++ )
						{
							// check the file name length with the settings
							// this was introduced because many faked results are long
							if( q->_results[n]._filename.size() > _parent->_widget_config->ui_spinbox_filelength->value() )
								continue;
		      
							if( _search[pos]->duplicate( q->_address.longIP(), q->_results[n] ) )
								continue;

							// check against advanced search
							std::string              query = _search[pos]->query_lower;
							std::vector<std::string> s_plus;
							std::vector<std::string> s_minus;
		    
							while(true)
								if( ! query.empty() )
									if( (query[query.size()-1] == '-') || (query[query.size()-1] == ' ') ||
											(query[query.size()-1] == '+') )
										query.erase(query.size()-1, 1);
									else
										break;
								else 
									break;
		      
							while( ! query.empty() )
								{
									std::string::size_type idx = query.find_last_of("+- ");
			
									if(idx != std::string::npos)
										{
											std::string s = query.substr(idx);
											if(s.size() > 1)
												if(s[0] == '-') s_minus.push_back(s.substr(1)); 
												else 
													if(s[0] == '+') s_plus.push_back(s.substr(1));
											query.erase(idx);
										}
									else
										{
											if( query.size() > 1 && query[0] == '+' ) s_plus.push_back(query.substr(1));
											query.erase();
										}
								}

// 							std::cout << "-------------------" << std::endl;
// 							for( int i = 0; i < s_plus.size(); ++i )
// 								std::cout << "+" << s_plus[i] << std::endl;
// 							for( int i = 0; i < s_minus.size(); ++i )
// 								std::cout << "-" << s_minus[i] << std::endl;
							
							std::string r = q->_results[n]._filename;
							bool        ok = true;
							for(t = 0; t < r.size(); ++t) r[t] = tolower(r[t]);
							for(t = 0; t < s_plus.size(); ++t) 
								if(r.find(s_plus[t]) == std::string::npos) ok = false;
							for(t = 0; t < s_minus.size(); ++t) 
								if(r.find(s_minus[t]) != std::string::npos) ok = false;
							if(!ok) continue;
							// end: check against advanced search
		      
		      
							// start content type check
							std::string type;
							std::string filename(q->_results[n]._filename);
							bool        found(false);
		    
							if(_search[pos]->_audio) 
								type += std::string(_parent->_widget_config->ui_lineedit_audio->text().latin1() );
							if( ! type.empty() ) 
								type += ";";
							if(_search[pos]->_video) 
								type += std::string(_parent->_widget_config->ui_lineedit_video->text(). latin1() );
							if( ! type.empty() ) 
								type += ";";
							if(_search[pos]->_images) 
								type += std::string(_parent->_widget_config->ui_lineedit_images->text().latin1() );
		    
							// now, type contains all extensions which are allowed
							if( ! type.empty() )
								{
									std::vector<std::string> type_vect;
									StringManipulation       sm(type);
			
									sm.split_to_vector(type_vect, ';');
			
									int j;
									for(j = 0; j < type_vect.size(); ++j)
										if( filename.find( ( "." + type_vect[j] ) ) != std::string::npos) 
											{
												found = true;
												break;
											}
								}
		      
							// now, found is true when an extension from valid extensions was found
		    
							// if no extension was found but "anything else" is selected
							if( _search[pos]->_any && ( ! found ) )
								{
									found = true;
			
									if( ! _search[pos]->_audio) 
										type += std::string(_parent->_widget_config->ui_lineedit_audio->text().latin1() );
									if( ! type.empty() ) 
										type += ";";
									if( ! _search[pos]->_video) 
										type += std::string(_parent->_widget_config->ui_lineedit_video->text().latin1() );
									if( ! type.empty() ) 
										type += ";";
									if( ! _search[pos]->_images) 
										type += std::string(_parent->_widget_config->ui_lineedit_images->text().latin1() );
			  
									std::vector<std::string> type_vect;
									StringManipulation       sm(type);
									sm.split_to_vector(type_vect, ';');
			
									int j;
									for(j = 0; j < type_vect.size(); ++j)
										if( filename.find( "." + type_vect[j] ) != std::string::npos )
											found = false;
								}
		    
							if( ! found ) 
								continue;
							// end content type check
		      
							// check status of host
							std::string vendor;
							int         color = GRAY;
							int         status = QueryHitEntry::Unknown;
		    
							if(q->_trailer.size() > 6)
								{
									vendor = q->_trailer.substr(0, 4);
			
									char flag  = q->_trailer[5];
									char flag2 = q->_trailer[6];
			
									if( flag & 4 )
										{
											if( flag2 & 4 )
												{
													status = QueryHitEntry::Busy;
													color = RED;
													if( _parent->_widget_config->ui_checkbox_ignorebusy->isChecked() )
														continue;
												}
											else
												{
													status = QueryHitEntry::Ready;
													color = GREEN;
												}
										}
			
									if( ((flag2 & 1)&&(flag & 1)) || q->_address.isPrivate() )  // firewalled
										{
											status |= QueryHitEntry::Firewalled;
											if( color == GREEN )
												color = YELLOW;

											if(_parent->_widget_config->ui_checkbox_ignorefirewalled->isChecked()) 
												continue;
										}
								}
							else
								{
									if(q->_address.isPrivate()) 
										{
											status |= QueryHitEntry::Firewalled;
											color = YELLOW;
										}
									if(_parent->_widget_config->ui_checkbox_ignorefirewalled->isChecked()) 
										continue;
								}
							//end check status

		    
							//check whether file already exists in shared directories
							//and whether it should be hidden
							//filename
							if( _parent->_widget_config->ui_checkbox_hidefilename->isChecked()
									&& _parent->_hash_table.find(q->_results[n]._filename) )
								continue;
							//filesize
							if( _parent->_widget_config->ui_checkbox_hidefilesize->isChecked()
									&& (_parent->_sharedsize_set.find(q->_results[n]._filesize) != 
											_parent->_sharedsize_set.end()) )
								continue;
		    
		      
							std::strstream str_size;
							str_size << q->_results[n]._filesize << std::ends;
							std::string ssize;
							ssize = str_size.str();
							str_size.freeze(false);
							ssize = StringManipulation::insertDelimiter(ssize, ',', 3);
		    
		    
							QueryHitEntry* qhe = new QueryHitEntry(q->_results[n]._filename,
																										 q->_results[n]._filesize,
																										 q->_results[n]._index,
																										 q->_speed,
																										 status,
																										 q->_address,
																										 q->_id_result, NULL);
		    
							_search[pos]->vSearchResults.push_back(qhe);
		    
							// tell InterruptedDownloads about a new query hit
							_parent->_interrupted_downloads->newQueryHit(q->_results[n]._filesize);
		    
							// create item
							QListViewItem *item;
		    
		    
							std::strstream str_hit;
							str_hit << _search[pos]->vSearchResults.size() << std::ends;
		    
							std::string content;
							if( filename.find_last_of(".") != std::string::npos )
								content = filename.substr( filename.find_last_of(".") + 1 );
		    
		    
							// if search list is empty just insert item
							if( _search[pos]->vSearchResults.empty() )
								item = new SearchViewItem( _search[pos]->sw->ui_listview_search, this,
																					 str_hit.str(),
																					 q->_results[n]._filename.c_str(),
																					 content.c_str(),
																					 ssize.c_str(), 
																					 q->_address.strIP().c_str(), 
																					 s->_user_agent.c_str(),
																					 q->_results[n]._info.c_str() );
							else
								// else search list is not empty => append item to the list
								if( ! _parent->_widget_search->ui_checkbox_group_size->isChecked() )
									item = new SearchViewItem(_search[pos]->sw->ui_listview_search, this, 
																						_search[pos]->vSearchResults.back()->item,
																						str_hit.str(),
																						q->_results[n]._filename.c_str(),
																						content.c_str(),
																						ssize.c_str(), 
																						q->_address.strIP().c_str(), 
																						s->_user_agent.c_str(),
																						q->_results[n]._info.c_str() );
								else
									{
										Search::SIZEMAP::iterator p = _search[pos]->_size_map.find(q->_results[n]._filesize);
			  
										if( p == _search[pos]->_size_map.end() )  // no search result with this size exists
											item = new SearchViewItem( _search[pos]->sw->ui_listview_search, this,
																								 _search[pos]->vSearchResults.back()->item,
																								 str_hit.str(),
																								 q->_results[n]._filename.c_str(),
																								 content.c_str(),
																								 ssize.c_str(), 
																								 q->_address.strIP().c_str(), 
																								 s->_user_agent.c_str(),
																								 q->_results[n]._info.c_str() );
										else
											{
												// if the item that we found is not the parent of a group
												// try the next one
												// since find() found an element with the same size we can be sure
												// that there must exist a parent
												while( ! static_cast<SearchViewItem*>(p->second->item)->_group_parent ) ++p;
			      
												item = new SearchViewItem( p->second->item, this, 
																									 _search[pos]->sw->ui_listview_search,
																									 str_hit.str(),
																									 q->_results[n]._filename.c_str(),
																									 content.c_str(),
																									 ssize.c_str(), 
																									 q->_address.strIP().c_str(), 
																									 s->_user_agent.c_str(),
																									 q->_results[n]._info.c_str() );
											}
									}

							// create pixmap
							Q_UINT32 speed = q->_speed;
							if(speed > 1100) speed = 1100;
		    
							( (SearchViewItem*) item )->setState( q->_speed, color );
							item->setPixmap(1, _speed_bar[ 62 * speed / 1100 ][color]);
		    
							str_hit.freeze(false);
		    
							_search[pos]->_size_map.insert( std::make_pair( q->_results[n]._filesize, qhe ) );
							QtellaSub::getInstance()->_search_item_set.insert(item);
		    
							// update label of widget
							static time_t last_update = 0;
		    
							if( time(NULL) - last_update > 1 )
								{
									last_update = time(NULL);
			
									std::strstream str;
									str << _search[pos]->query << " (" 
											<< _search[pos]->vSearchResults.size() << ")";
			
									//if(_parent->ui_tabwidget_search->currentPage() != _search[pos]->sw)
									//str << "*";
			
									str << std::ends;
			
									_parent->_widget_search->ui_tabwidget_search->changeTab((QWidget*)_search[pos]->sw, str.str());
									str.freeze(false);
								}
		    
							_search[pos]->vSearchResults.back()->item = item;
						}
	      }
	      break;
	      
	    case CMD_PUSH:
	      {
#ifdef _DEBUG
		qDebug("push");
#endif
		std::auto_ptr<Push> p(msg.getPush());
		
		PongCache::getInstance()->addHost(msg.id(), msg.hops(), s->_servant_number);
		
		_statistic.in_push_n++;
		_statistic.in_push_b += msg.size();
		
		if(p->_id_payload == _id)
		  _parent->upload_manager->addPushUpload(*p);
		else
		  if(p->_ttl >= 1)
		    {
		      p->_ttl--;
		      p->_hops++;
		      int i;
		      for(i = 0; i < _servants.size(); ++i)
			if(_servants[i] != s)
			  {
			    _servants[i]->sendMessage(p->_data);
			    _statistic.out_push_n++;
			    _statistic.out_push_b += p->_data.size();
		      }
		    }
#ifdef _DEBUG
		qDebug("exit push");
#endif
	      }
	      break;
	      
	    case CMD_BYE:
	      {
#ifdef COUT_OUTPUT	      
		std::cout << "received bye packet" << std::endl;
#endif
		std::auto_ptr<Bye> p( msg.getBye() );
		
		std::strstream str;
		str << "Bye-Packet. Code: " << p->_code << " Servent: <" << s->_user_agent 
		    << "> Message: <" << p->_message << ">" 
		    << " Buffer size: " << s->getBufferSize() << std::ends;
		Logging::getInstance()->log( Logging::Info, str.str() );
		str.freeze( false );

		s->close();
	      }
	      break;

	    default:
	      {
#ifdef COUT_OUTPUT
          std::cout << "received invalid message" << std::endl;
#endif
          std::strstream str;
          str << "Received invalid message. Servent: " << s->_user_agent << std::ends;
          Logging::getInstance()->log( Logging::Error, str.str() );
          str.freeze( false );
          
          //s->setByeCode(501);
          //s->close();
	      }
	    } // switch
	} // while
    } // try
  catch(...) 
    { 
      //std::cerr << "EXC Connections::checkMessages" << std::endl; 
      qDebug("Connections::checkMessages Exception");
      s->_message_buffer.clear();
    }
}


void Connections::sendAll(std::string data)
{
  try
    {
      int i;
      for(i = 0; i < _servants.size(); ++i)
	{
	  _servants[i]->sendMessage(data, false);
	  _statistic.out_push_n++;
	  _statistic.out_push_b += data.size();
	}
      
    } 
  catch(...) 
    { 
      std::cerr << "EXC Connections::sendAll" << std::endl; 
    }
}


std::string Connections::toHex(std::string data)
{
  std::string s;

  for(int i = 0; i < data.size(); ++i)
    {
      std::strstream str;
      str.width(2);
      str.fill('0');
      str.unsetf(std::ios::dec);
      str.setf(std::ios::hex);
      int a = (unsigned char)data[i];
      str << a << std::ends;
      s += str.str();
      str.freeze(false);
    }

  return s;
}

static void purify(const std::string &query, std::string &result)
{
	// I'm using a buffer, because I don't think string::+= is guaranteed to be in amortized constant time
	char buffer[query.length()]; // We won't need more
	char *q = buffer;
	const char *p = query.data();  // I should use an iterator. I'm a bad guy.
	bool lastWasSpace = false;
	for(int l = query.length(); l; l--, p++)
		if (*p != '+' && *p != '-' && *p != ' ') {
 		  if (lastWasSpace && q > buffer) *q++ = ' ';
 		  *q++ = *p;
 		  lastWasSpace = false;
		} else
 		  lastWasSpace = true;
	result.assign(buffer, q - buffer);
}
 
void Connections::sendSearch(const Search &theSearch)
{
	std::string s;
	purify(theSearch.query, s);
	
	int ttl = _parent->_widget_config->ui_spinbox_ttl->value();
	Query q(ttl, 0, theSearch.id, theSearch._min_speed, s);
	
	for(std::vector<Servent*>::iterator pos = _servants.begin(); pos != _servants.end(); ++pos) {
		(*pos)->sendMessage(q._data, false);
		
		_statistic.out_query_n++;
		_statistic.out_query_b += q._data.size();
		
		(*pos)->updateLastSearch();  // update time of last search
	}
}

void Connections::search(std::string query, SearchWidget *sw, const SearchParameters *sp)
{
  try
    {
      Q_UINT16 speed[] = {0, 64, 128, 350, 1000, 3000};

      std::string search_id = createID();
      int         speed_idx = _parent->_widget_search->ui_combobox_searchspeed->currentItem();

			Q_UINT16 minimum_speed;
			Search *so;
			if (sp) {
				minimum_speed = sp -> _speed;
				so = new Search(search_id, sw, sp -> _speed, sp -> _audio, 
												sp -> _video, sp -> _images, sp -> _any);
			}	else {
				minimum_speed = speed[speed_idx];
				so = new Search( search_id, sw, minimum_speed,
												 _parent->_widget_search->ui_checkbox_searchaudio->isChecked(),
												 _parent->_widget_search->ui_checkbox_searchvideo->isChecked(),
												 _parent->_widget_search->ui_checkbox_searchimages->isChecked(),
												 _parent->_widget_search->ui_checkbox_searchany->isChecked() );
			}
			
			_search.push_back(so);

			_search.back()->query = query;
			
			for( int i = 0; i < query.size(); ++i )
				so->query_lower += tolower( query[i] );
			
			sendSearch(*so);
      
      if (!sp) SearchPersistence::save(_search);
    } 
  catch(...) 
    { 
      std::cerr << "EXC Connections::search" << std::endl; 
    }
}


void Connections::slotRemoveHost()
{
  #ifdef QTELLA_DEBUG
    std::clog << "Connections: remove host" << std::endl;
  #endif

  try{

  QListViewItem *item = _parent->_widget_connections->ui_listview_connections->currentItem();

  if(item)
    {
      std::vector<class Servent*>::iterator pos = _servants.begin();

      for(pos; pos != _servants.end(); )
	if( (*pos)->_item == item )
	  {
	    (*pos)->setByeCode(201);
	    delete *pos;
	    pos = _servants.erase(pos);
	    break;
	  }
	else
	  ++pos;
    }

  } catch(...) { std::cerr << "EXC Connections::slotRemoveHost" << std::endl; }

  #ifdef QTELLA_DEBUG
    std::clog << "Connections: ok check host" << std::endl;
  #endif
}



void Connections::slotAddHost()
{
#ifndef SHARP
  try
    {
      std::string hostname = _parent->_widget_connections->ui_lineedit_host->text().latin1();
      std::string port = _parent->_widget_connections->ui_lineedit_port->text().latin1();

      Host host = Host(Address(hostname+":"+port));
      
      QListViewItem *item = 
        new QListViewItem( _parent->_widget_connections->ui_listview_connections, 
                           host.address.toString().c_str(), QObject::tr("Connecting...") );

      _servants.push_back(new Servent(this, _id, item));
      _servants.back()->connect(host.address);
      _parent->_widget_connections->ui_listview_connections->insertItem(item);
      
    } 
  catch(...) 
    { 
      std::cerr << "EXC Connections::slotAddHost" << std::endl; 
    }
#endif
}



void Connections::slotMaxServents(int value)
{
  _max_servants = value;
}


void Connections::slotListClear()
{
  _parent->_widget_connections->ui_listbox_hostlist->clear();
}


void Connections::slotListConnect()
{
  int i = _parent->_widget_connections->ui_listbox_hostlist->currentItem();

  if(i != -1)
    {
      std::string addr = _parent->_widget_connections->ui_listbox_hostlist->text(i).latin1();

      Host host = Host(Address(addr));
      
      QListViewItem *item = 
         new QListViewItem(_parent->_widget_connections->ui_listview_connections, host.address.toString().c_str(), 
						  QObject::tr("Connecting...") );

      if(!_parent->timer_connection->isActive()) _parent->timer_connection->start(500);

      _servants.push_back(new Servent(this, _id, item));
      _servants.back()->connect(host.address);
      _parent->_widget_connections->ui_listview_connections->insertItem(item);
    }
}


void Connections::slotListRemove()
{
  int i = _parent->_widget_connections->ui_listbox_hostlist->currentItem();

  if(i != -1)
    _parent->_widget_connections->ui_listbox_hostlist->removeItem(i);
}


void Connections::slotUpdateStatistic()
{
  // sha1 message statistic
  std::strstream sha1;
  sha1.setf( std::ios::fixed );
  sha1 << std::setprecision(2) << 100 * _statistic._n_sha1_queries / _statistic._n_total_queries
       << "%" << std::ends;
  _parent->_widget_stats->ui_textlabel_sha1_queries->setText( sha1.str() );

  // total incoming messages, dropped, blocked
  _parent->_widget_stats->ui_textlabel_mess_total->setText( StringManipulation::toString( _all_packets).c_str() );
  _parent->_widget_stats->ui_textlabel_mess_dropped->setText( StringManipulation::toString( _ignored_packets ).c_str() );
  _parent->_widget_stats->ui_textlabel_mess_blocked->setText( StringManipulation::toString( _blocked_packets ).c_str() );

  double ma = 0;
  double mb = 0;
  
  if( _all_packets > 0 )
    {
      ma = static_cast<double>( _ignored_packets ) * 100 / static_cast<double>( _all_packets );
      mb = static_cast<double>( _blocked_packets ) * 100 / static_cast<double>( _all_packets );
    }

  std::strstream astr;
  std::strstream bstr;

  astr.setf( std::ios::fixed );
  bstr.setf( std::ios::fixed );
  
  astr << std::setprecision(2) << ma << "%" << std::ends;
  bstr << std::setprecision(2) << mb << "%" << std::ends;

  _parent->_widget_stats->ui_textlabel_mess_dropped_p->setText( astr.str() );
  _parent->_widget_stats->ui_textlabel_mess_blocked_p->setText( bstr.str() );

  astr.freeze( false );
  bstr.freeze( false );

  // incoming messages  
  _parent->_widget_stats->ui_in_ping_n->setText( _statistic.str(_statistic.in_ping_n, 1).c_str() );
  _parent->_widget_stats->ui_in_pong_n->setText( _statistic.str(_statistic.in_pong_n, 1).c_str() );
  _parent->_widget_stats->ui_in_query_n->setText( _statistic.str(_statistic.in_query_n, 1).c_str() );
  _parent->_widget_stats->ui_in_hit_n->setText( _statistic.str(_statistic.in_hit_n, 1).c_str() );
  _parent->_widget_stats->ui_in_push_n->setText( _statistic.str(_statistic.in_push_n, 1).c_str() );

  _parent->_widget_stats->ui_in_all_n->setText( _statistic.str(_statistic.in_all_n(), 1).c_str() );

  _parent->_widget_stats->ui_in_ping_b->setText( _statistic.str(_statistic.in_ping_b, 1).c_str() );
  _parent->_widget_stats->ui_in_pong_b->setText( _statistic.str(_statistic.in_pong_b, 1).c_str() );
  _parent->_widget_stats->ui_in_query_b->setText( _statistic.str(_statistic.in_query_b, 1).c_str() );
  _parent->_widget_stats->ui_in_hit_b->setText( _statistic.str(_statistic.in_hit_b, 1).c_str() );
  _parent->_widget_stats->ui_in_push_b->setText( _statistic.str(_statistic.in_push_b, 1).c_str() );

  _parent->_widget_stats->ui_in_all_b->setText( _statistic.str(_statistic.in_all_b(), 1).c_str() );

  // outgoing messages
  _parent->_widget_stats->ui_out_ping_n->setText( _statistic.str(_statistic.out_ping_n, 1).c_str() );
  _parent->_widget_stats->ui_out_pong_n->setText( _statistic.str(_statistic.out_pong_n, 1).c_str() );
  _parent->_widget_stats->ui_out_query_n->setText( _statistic.str(_statistic.out_query_n, 1).c_str() );
  _parent->_widget_stats->ui_out_hit_n->setText( _statistic.str(_statistic.out_hit_n, 1).c_str() );
  _parent->_widget_stats->ui_out_push_n->setText( _statistic.str(_statistic.out_push_n, 1).c_str() );

  _parent->_widget_stats->ui_out_all_n->setText( _statistic.str(_statistic.out_all_n(), 1).c_str() );

  _parent->_widget_stats->ui_out_ping_b->setText( _statistic.str(_statistic.out_ping_b, 1).c_str() );
  _parent->_widget_stats->ui_out_pong_b->setText( _statistic.str(_statistic.out_pong_b, 1).c_str() );
  _parent->_widget_stats->ui_out_query_b->setText( _statistic.str(_statistic.out_query_b, 1).c_str() );
  _parent->_widget_stats->ui_out_hit_b->setText( _statistic.str(_statistic.out_hit_b, 1).c_str() );
  _parent->_widget_stats->ui_out_push_b->setText( _statistic.str(_statistic.out_push_b, 1).c_str() );

  _parent->_widget_stats->ui_out_all_b->setText( _statistic.str(_statistic.out_all_b(), 1).c_str() );

  // hits
  _parent->_widget_stats->ui_hits_qtel_n->setText( _statistic.str(_statistic.hits_qtel_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_lime_n->setText( _statistic.str(_statistic.hits_lime_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_bear_n->setText( _statistic.str(_statistic.hits_bear_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_gnot_n->setText( _statistic.str(_statistic.hits_gnot_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_gtkg_n->setText( _statistic.str(_statistic.hits_gtkg_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_snut_n->setText( _statistic.str(_statistic.hits_snut_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_xolo_n->setText( _statistic.str(_statistic.hits_xolo_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_gnuc_n->setText( _statistic.str(_statistic.hits_gnuc_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_mrph_n->setText( _statistic.str(_statistic.hits_mrph_n, 1).c_str() );
  _parent->_widget_stats->ui_hits_othe_n->setText( _statistic.str(_statistic.hits_othe_n, 1).c_str() );

  unsigned long a = _statistic.hits_all_n();
  if( a > 0 )
    {
      _parent->_widget_stats->ui_hits_qtel_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_qtel_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_lime_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_lime_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_bear_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_bear_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_gtkg_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_gtkg_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_gnot_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_gnot_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_snut_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_snut_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_xolo_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_xolo_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_gnuc_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_gnuc_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_mrph_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_mrph_n)/a, 1).c_str() );
      _parent->_widget_stats->ui_hits_othe_p->setText( _statistic.str(static_cast<double>(100*_statistic.hits_othe_n)/a, 1).c_str() );
    }

  // down / uploads
  _parent->_widget_stats->ui_loads_usucc->setText( _statistic.str(_statistic.loads_usucc, 0).c_str() );
  _parent->_widget_stats->ui_loads_uabor->setText( _statistic.str(_statistic.loads_uabor, 0).c_str() );
  _parent->_widget_stats->ui_loads_usize->setText( _statistic.str(_statistic.loads_usize, 1).c_str() );
  _parent->_widget_stats->ui_loads_dsucc->setText( _statistic.str(_statistic.loads_dsucc, 0).c_str() );
  _parent->_widget_stats->ui_loads_dabor->setText( _statistic.str(_statistic.loads_dabor, 0).c_str() );
  _parent->_widget_stats->ui_loads_dsize->setText( _statistic.str(_statistic.loads_dsize, 1).c_str() );

  // shared files
  _parent->_widget_stats->ui_files_n->setText( _statistic.str(_statistic.shared_files, 0).c_str() );
  _parent->_widget_stats->ui_files_b->setText( _statistic.str(_statistic.shared_size, 1).c_str() );

  // uptime
  QDateTime* dt = new QDateTime( QDate::currentDate(), QTime::currentTime() );

  int sto = _uptime->secsTo(*dt);
  
  int days = sto / 86400;
  sto -= days * 86400;
  int h = sto / 3600;
  sto -= h * 3600;
  int m = sto / 60;
  sto -= m * 60;
  int s = sto;

  std::strstream str;

  if(days > 0) str << days << "d ";
  if(h > 0) str << h << "h ";
  if(h > 0 || m > 0) str << m << "m ";
  if(days==0 && h==0) str << s << "s";
  str << std::ends;

  _parent->_widget_stats->ui_uptime->setText( str.str() );
  str.freeze(false);
  delete dt;
}


void Connections::slotBlockHost()
{
  QListViewItem *item = _parent->_widget_connections->ui_listview_connections->currentItem();

  if(item)
    {
      std::string s(item->text(0).latin1());
      s = s.substr(0, s.find(":"));
      _parent->_widget_config->ui_listbox_blockedhosts->insertItem(s.c_str());
    }
}


void Connections::slotShowHandshake()
{
  QListViewItem *item = _parent->_widget_connections->ui_listview_connections->currentItem();

  if(item)
    {
      std::string header;

      for(int i = 0; i < _servants.size(); ++i)
	if( _servants[i]->_item == item )
	  header = _servants[i]->_header;

      QMessageBox::information(0, "Handshake", header.c_str(), QMessageBox::Ok);
    }
}


const void Connections::closeSocket( QSocket* socket )
{
  if( socket )
    _sockets_to_close.push_back( std::make_pair( time(NULL), socket ) );
  else
    {
      time_t t = time(NULL);
      std::list< std::pair< time_t, QSocket* > >::iterator pos = _sockets_to_close.begin();
      
      while( pos != _sockets_to_close.end() )
        if( (t - pos->first) > 3 )
          {
#ifdef _DEBUG
            qDebug( "Connections: closed connection" );
#endif
            delete pos->second;
            _sockets_to_close.erase(pos++);
          }
        else
          ++pos;
    }
}


const bool Connections::incomingSlotsFree()
{
  int          in_connected = 0;
  
  for(int j = 0; j < _servants.size(); ++j)
    if(_servants[j]->getDirection() == Servent::Incoming) ++in_connected;

  if( in_connected >= _parent->_widget_connections->ui_spinbox_inconnects->value() )
    return false;

  return true;
}


Connections* Connections::getInstance()
{
  return _this;
}


const bool Connections::hostBlocked( const std::string& ip )
{
  for( int i = 0; i < _parent->_widget_config->ui_listbox_blockedhosts->count(); ++i )
    {
      std::string s = static_cast<const char*>( _parent->_widget_config->ui_listbox_blockedhosts->text( i ) );
      if( s == ip )
        return true;
    }

  return false;
}


const void Connections::incIgnoredPackets()
{
  ++_ignored_packets;
}


const void Connections::incAllPackets()
{
  ++_all_packets;
}

void Connections::slotResubmitQueries()
{
	for(std::vector<Search *>::iterator i = _search.begin(); i != _search.end(); i++) {
		Search &s = **i;
		if (!s.active) continue;
		// Rather than creating a brand new Search with everything identical to the
		// previous one, except the id, we just change the id.
		s.mutateID( createID() );
		sendSearch(s);
	}
}
