#include "../include/DownloadTo.h"

#include "QtellaSub.h"

#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qstring.h>

/* 
 *  Constructs a DownloadTo which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
DownloadTo::DownloadTo( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : BDownloadTo( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
DownloadTo::~DownloadTo()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void DownloadTo::slotOtherClicked(int state)
{
  if( state == 2 )
    ui_checkbox_shared->setChecked(false);
  if( state == 0 )
    ui_checkbox_shared->setChecked(true);
}
/* 
 * public slot
 */
void DownloadTo::slotSelectDirectory()
{
#ifndef SHARP
  std::string l = QtellaSub::getInstance()->_last_download_to_dir;

  QFileDialog d( l.c_str(), "All (*)", (QWidget*)0, "Select Directory", true);

  d.setMode(QFileDialog::DirectoryOnly);

  if(d.exec() == QDialog::Accepted)
    {
      ui_lineedit->setText( d.selectedFile() );
      QtellaSub::getInstance()->_last_download_to_dir = d.selectedFile().latin1();
    }
#endif
}

/* 
 * public slot
 */
void DownloadTo::slotSharedClicked(int state)
{
  if( state == 2 )
    ui_checkbox_other->setChecked(false);
  if( state == 0 )
    ui_checkbox_other->setChecked(true);
}

