#include "DownloadViewItem.h"

#include <qstring.h>
#include <qobject.h>
#include <string>

DownloadViewItem::DownloadViewItem(QListView *parent) 
  : QListViewItem(parent)
{
}


DownloadViewItem::DownloadViewItem(QListViewItem *parent) 
  : QListViewItem(parent)
{
}

#if QT_VERSION >= 300
int DownloadViewItem::compare( QListViewItem* item, int column, bool ascending ) const
{
  DownloadViewItem* i = ( DownloadViewItem* )item;

  switch( column )
	{
	case 0:
	  {
		std::string file1 = static_cast< const char* >( text(0).lower() );
		std::string file2 = static_cast< const char* >( i->text(0).lower() );
		if( file1 < file2 )
		  return -1;
		else 
		  if( file1 == file2 )
			return 0;
		  else
			return 1;
		break;
	  }

	case 7:
	  {
		std::string client1 = static_cast< const char* >( text(7).lower() );
		std::string client2 = static_cast< const char* >( i->text(7).lower() );
		if( client1 < client2 )
		  return -1;
		else 
		  if( client1 == client2 )
			return 0;
		  else
			return 1;
		break;
	  }
	}
}

#else

QString DownloadViewItem::key(int column, bool ascending) const
{
  QString status;

  if( column == 1 || column == 3 )
	{
	  if( text(1).contains( QObject::tr("Completed") ) ) status = "A";
	  else
		if( text(1).contains( QObject::tr("Connected") ) ) status = "B";
		else
		  if( text(1).contains( QObject::tr("Connecting") ) ) status = "C";
		  else
			if(text(1).contains( QObject::tr("Push") )) status = "D";
			else
			  if(text(1).contains( QObject::tr("Queue") )) status = "E";
			  else
				if(text(1).contains( QObject::tr("Close") )) status = "F";
				else
				  if(text(1).contains( QObject::tr("Busy") )) status = "G";
				  else
					if(text(1).contains( QObject::tr("Time") )) status = "H";
					else
					  if(text(1).contains( QObject::tr("Error") )) status = "I";
					  else
						if(text(1).contains( QObject::tr("Abort") )) status = "J";
						else
						  if(text(1).contains( QObject::tr("Exist") )) status = "K";
	}

  QString ret;

  switch(column)
    {
    case 0: // filename
      ret = text( 0 ).lower().left( 30 );
      break;

    case 1:  // status
      ret = status + text( 3 ).rightJustify( 3, '0' ) + text( 0 );
      break;

    case 2:  // filesize
      ret = text( 2 ).rightJustify( 15, '0' );
      break;

    case 3:  // progress
      ret = text( 3 ).rightJustify( 6, '0' ) + status;
      break;

    case 4:  // host
      ret = text( 4 );
      break;

    case 5:  // bandwidth
      ret = text( column ).rightJustify( 11, '0' );

    case 6:  // time
      ret = text( column ).rightJustify( 10, '0' );
      break;

    case 7:  // client
      ret = text( 7 );
      break;
    }

  return ret;
}

#endif
