#include "HashTable.h"

#include <cctype>

HashTable::HashTable()
{
  _n = 1009;
  _vector.resize(_n);
}

void HashTable::insert(const std::string& value)
{
  unsigned     h = hash_value(value);
  std::string  s;

  lower(value, s);
  _vector[h].push_back(s);
}

void HashTable::remove(const std::string& value)
{
  unsigned     h = hash_value(value);
  std::string  s;

  lower(value, s);
  
  std::list<std::string>::iterator pos = _vector[h].begin();

  while( pos != _vector[h].end() )
    if( *pos == s )
      {
	_vector[h].erase(pos);
	break;
      }
    else ++pos;
}

bool HashTable::find(const std::string& value)
{
  unsigned     h = hash_value(value);
  std::string  s;
  
  lower(value, s);
  
  std::list<std::string>::iterator pos = _vector[h].begin();

  while( pos != _vector[h].end() )
    if( *pos == s )
      return true;
    else ++pos;

  return false;
}

void HashTable::clear()
{
  for(int i = 0; i < _n; ++i) _vector[i].clear();
}

unsigned HashTable::hash_value(const std::string& value)
{
  unsigned long v = 0;
  std::string       s;

  lower(value, s);

  for(int i = 0; i < s.size(); ++i)
    v = v + (unsigned char)s[i];

  return (v % _n);
}

void HashTable::lower(const std::string& src, std::string& dst)
{
  for(int i = 0; i < src.size(); ++i)
    dst += tolower(src[i]);
}

void HashTable::toString()
{
//   for(int i = 0; i < _n; ++i)
//     if(_vector[i].size() > 0) cout << _vector[i].size() << endl;
}
