#include <qstring.h>

#include "HttpTransactor.h"

void HttpTransactor::data(const QByteArray &data, QNetworkOperation *op)
{
      _reply += data;
}

void HttpTransactor::finished(QNetworkOperation *op)
{
      emit finished(*op, *this);
}

bool HttpTransactor::start(const QString &url)
{
      _reply = "";
      _operator = url;
      return _operator.get();
}

HttpTransactor::HttpTransactor()
{
      connect(&_operator, SIGNAL(finished(QNetworkOperation *)), 
	      this, SLOT(finished(QNetworkOperation *)));
      connect(&_operator, SIGNAL(data(const QByteArray &, QNetworkOperation *)), 
	      this, SLOT(data(const QByteArray &, QNetworkOperation *)));

}
