#include "Icon.h"
#include <qimage.h>
#include <string>

Icon*     Icon::_instance = NULL;
QPixmap*  Icon::_remove = NULL;
QPixmap*  Icon::_green_ball = NULL;
QPixmap*  Icon::_yellow_ball = NULL;
QPixmap*  Icon::_red_ball = NULL;
QPixmap*  Icon::_grey_ball = NULL;
QPixmap*  Icon::_smile = NULL;
QPixmap*  Icon::_green_smile = NULL;
QPixmap*  Icon::_research = NULL;
QPixmap*  Icon::_remove_research = NULL;

Icon::Icon()
{
  std::string dir(PIXMAP_DIR);

  if( ! dir.empty() )
    if( dir[dir.size()-1] != '/' ) dir.append("/");

  QImage remove( (dir + "remove.xpm").c_str() );
  _remove = new QPixmap();
  _remove->convertFromImage(remove);

  QImage research( (dir + "research.xpm").c_str() );
  _research = new QPixmap();
  _research->convertFromImage(research);

  QImage remove_research( (dir + "removeresearch.xpm").c_str() );
  _remove_research = new QPixmap();
  _remove_research->convertFromImage(remove);

  QImage green( (dir + "ball_g.xpm").c_str() );
  _green_ball = new QPixmap();
  _green_ball->convertFromImage(green);

  QImage yellow( (dir + "ball_y.xpm").c_str() );
  _yellow_ball = new QPixmap();
  _yellow_ball->convertFromImage(yellow);

  QImage red( (dir + "ball_r.xpm").c_str() );
  _red_ball = new QPixmap();
  _red_ball->convertFromImage(red);

  QImage grey( (dir + "ball_d.xpm").c_str() );
  _grey_ball = new QPixmap();
  _grey_ball->convertFromImage(grey);

  QImage smile( (dir + "smile.xpm").c_str() );
  _smile = new QPixmap();
  _smile->convertFromImage(smile);

  QImage green_smile( (dir + "gsmile.xpm").c_str() );
  _green_smile = new QPixmap();
  _green_smile->convertFromImage(green_smile);
}

Icon* Icon::getInstance()
{
  if(!_instance) return _instance = new Icon();
  return _instance;
}

QPixmap* Icon::getRemove()
{
  return _remove;
}

QPixmap* Icon::getGreenBall()
{
  return _green_ball;
}

QPixmap* Icon::getYellowBall()
{
  return _yellow_ball;
}

QPixmap* Icon::getRedBall()
{
  return _red_ball;
}

QPixmap* Icon::getGreyBall()
{
  return _grey_ball;
}

QPixmap* Icon::getSmile()
{
  return _smile;
}

QPixmap* Icon::getGreenSmile()
{
  return _green_smile;
}

QPixmap* Icon::getResearch()
{
  return _research;
}

QPixmap* Icon::getRemoveResearch()
{
  return _remove_research;
}
