#include "IconTabBar.h"

#include <iostream>
#include <qtabbar.h>
#include <qtabwidget.h>
#include <qtabdialog.h>
#include <qiconset.h>
#include <qpainter.h>

IconTabBar::IconTabBar(QWidget *parent, const char *name)
  : QTabBar(parent, name)
{
  //connect(this, SIGNAL(selected(int)), parent, 
}

//! For our ends we just had to reimplement mouseReleaseEvent()

void IconTabBar::mouseReleaseEvent(QMouseEvent *e)
{

  if (e->button() != LeftButton)
    return;
  
  /* emit signal that mouse was within icon. We assume that mousePressEvent()
     has been called before and the correct tab has already been selected.  */
  if (withinIcon(tab(currentTab()), e->pos()))
    {
      emit iconPressed();
    }

}

bool IconTabBar::withinIcon(const QTab * t, const QPoint & point)
{

  if (t == 0 ||
#if QT_VERSION < 300
       t->iconset
#else
       t->iconSet()
#endif
      == 0 )
    return false;

#if QT_VERSION < 300
  QRect r(t->r);
#else
  QRect r(t->rect());
#endif

  /* don't know if that's a good way, we could destroy something if IconTabBar */
  QPainter painter(this);
  painter.setFont(font());

  int pixw = 0;
  int pixh = 0;
  int iw = 0;

#if QT_VERSION < 300
  pixw = t->iconset->pixmap( QIconSet::Small, QIconSet::Normal ).width();
  pixh = t->iconset->pixmap( QIconSet::Small, QIconSet::Normal ).height();
#else
  pixw = t->iconSet()->pixmap( QIconSet::Small, QIconSet::Normal ).width();
  pixh = t->iconSet()->pixmap( QIconSet::Small, QIconSet::Normal ).height();
#endif
  iw = pixw + 2;

#if QT_VERSION < 300 
  int w = iw + painter.fontMetrics().width(t->label) + 4;
#else
  int w = iw + painter.fontMetrics().width(t->text()) + 4;
#endif
  int h = QMAX(painter.fontMetrics().height() + 4, pixh);

  QRect tmp(r.left() + (r.width()-w)/2 - 3, r.top() + (r.height()-h)/2, w, h);

  QRect p(tmp.left() + 2, tmp.center().y() - pixh / 2, pixw, pixh);
  if (!p.isEmpty())
    {
      return p.contains(point);
    }
    
  return false;
}
