#include "IncomingConnect.h"
#include "InConnection.h"
#include "QtellaSub.h"

#include <qsocket.h>

#undef _DEBUG

IncomingConnect::IncomingConnect(Q_UINT16 port, int backlog) 
  : QServerSocket(port, backlog, (QObject*)0, (const char*)0)
{
}


void IncomingConnect::newConnection(int socket)
{
  if( ! QtellaSub::getInstance()->_incoming_allowed )
    {
#ifdef _DEBUG
      qDebug( "IncomingConnect: rejected incoming connection" );
#endif
      QSocket s;
      s.setSocket(socket);
      return;
    }

  std::list<InConnection*>::iterator pos = _in_list.begin();

  while( pos != _in_list.end() )
    if( (*pos)->state() == InConnection::Closed ) 
      {
	delete *pos;
	pos = _in_list.erase(pos);
      }
    else ++ pos;

  _in_list.push_back(new InConnection(socket));

#ifdef _DEBUG
  qDebug( "IncomingConnect: added new connection <%d>.", _in_list.size() );
#endif
}


IncomingConnect::~IncomingConnect()
{
}
