#include "Interface.h"

#include <sys/types.h>

#if !defined(_WIN32)
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#endif

#ifdef __linux__
#include <linux/sockios.h>
#include <linux/if.h>
#else
#if !defined(_WIN32)
#include <sys/sockio.h>
#include <net/if.h>
#endif
#endif

#ifdef _WIN32
#include <winsock2.h>
#endif

#include <iostream>
#include <strstream>
#include <fstream>

Interface::Interface()
{
}

void Interface::getIfList(std::vector<std::string>& v)
{
  std::fstream f;
  char         buffer[1024];

#if !defined(_WIN32)
  f.open("/proc/net/dev", std::ios::in);
  if(f.is_open())
    while(f.getline(buffer, 1024))
      {
	std::string s(buffer);
	std::string::size_type idx = s.find(":");
	
	if(idx == std::string::npos) continue;
	
	s = s.substr(0, idx);
	idx = s.find_last_of(" ");
	if(idx != std::string::npos) s = s.substr(idx+1);
	v.push_back(s);
      }
#else
  //Code requires at least Winsock 1.1
  WORD wVersionRequested = MAKEWORD(1, 1);
  WSADATA wsaData;
  int err = WSAStartup(wVersionRequested, &wsaData);
  if ((LOBYTE(wsaData.wVersion) != 1) || (HIBYTE(wsaData.wVersion) != 1))
    {
      //qDebug("Failed to find a usable winsock stack which supports Winsock 1.1");
      return;
    }


  if (gethostname(buffer, sizeof(buffer)))
    {
      return;
    }
  
  //get host information from the host name
  HOSTENT* pHostEnt = gethostbyname(buffer);
  if (pHostEnt == NULL)
    {
      //qDebug("Failed in call to gethostbyname, WSAGetLastError returns %d\n"), WSAGetLastError();
      return;
    }
  
  //check the length of the IP adress
  if (pHostEnt->h_length != 4)
    {
      //qDebug("IP address returned is not 32 bits !!\n");
      return;
    }
  
  //call the virtual callback function in a loop
  int nAdapter = 0;
  while (pHostEnt->h_addr_list[nAdapter])
    {
      in_addr address;
      CopyMemory(&address.S_un.S_addr, pHostEnt->h_addr_list[nAdapter], pHostEnt->h_length);
      v.push_back(inet_ntoa(address));
      nAdapter++;
    }
  WSACleanup();
#endif
}


std::string Interface::getIfAddress(std::string iface)
{
#if !defined(_WIN32)
  std::string ifa(iface + std::string("\0", 1));
  std::strstream str;
  struct ifreq s;

  int fd = socket(PF_INET, SOCK_DGRAM, 0);

#ifdef __linux__
  for(int i=0; i < iface.size()+1; ++i) s.ifr_ifrn.ifrn_name[i] = ifa[i];
#else
  for(int i=0; i < iface.size()+1; ++i) s.ifr_name[i] = ifa[i];
#endif

  if( ioctl(fd, SIOCGIFADDR, &s) ) return "";

  for(int i = 2; i < 6; ++i)
    {
      str << static_cast<unsigned int>(static_cast<unsigned char>(s.ifr_addr.sa_data[i]));
      if(i < 5) str << "."; else str << std::ends; 
    } 
  
  std::string sret(str.str());
  str.freeze(false);
  return sret;
#else
  return iface;
#endif
}
