#include "InterruptedDownloads.h"
#include "InterruptedFile.h"
#include "QtellaSub.h"
#include "Logging.h"
#include "StringManipulation.h"
#include "SearchDialog.h"
#include "InterruptedFileSearch.h"
#include "Icon.h"
#include "DownloadManager.h"
#include "ResumeHost.h"
#include "InterruptedViewItem.h"
#include "WidgetInterrupted.h"

#include <qlistview.h>
#include <qlistview.h>
#include <qdir.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qlineedit.h>
#include <qaccel.h>

#include <strstream>
#include <iostream>
#include <iomanip>
#include <fstream>

InterruptedDownloads* InterruptedDownloads::_this = NULL;
#ifndef SHARP
QMutex                InterruptedDownloads::_index_mutex;
#endif

InterruptedDownloads::InterruptedDownloads(QtellaSub* parent, std::string directory)
  : _parent(parent)
{
  _this = this;

  if(!directory.empty())
    if(directory[directory.size()-1] != '/') directory += "/";
  _directory = directory;
#ifndef SHARP  
  _context_menu = new QPopupMenu( parent->_widget_interrupted, tr("Interrupted Downloads") );
  _context_menu->insertItem( tr("Search for file"), this, SLOT(searchSelectedFiles()), 
			     QAccel::stringToKey( tr("CTRL+S") ) );
  _context_menu->insertItem( tr("Resume"), this, SLOT(resumeSelectedFiles()), 
			     QAccel::stringToKey( tr("CTRL+R") ) );
  _context_menu->insertItem( tr("Resume from host"), this, SLOT(resumeFromHost()), 
			     QAccel::stringToKey( tr("CTRL+H") ) );
  _context_menu->insertSeparator();
  _context_menu->insertItem( tr("Abort Download"), this, SLOT(abortSelectedFiles()), 
			     QAccel::stringToKey( tr("CTRL+A") ) );
  _context_menu->insertItem( tr("Delete from disc"), this, SLOT(deleteSelectedFiles()), 
			     QAccel::stringToKey( tr("CTRL+Del") ) );
  _context_menu->insertSeparator();
  _context_menu->insertItem( tr("Launch"), parent, SLOT(slotLaunchInterruptedFile()), 
			     QAccel::stringToKey( tr("CTRL+L") ) );
#endif
  QFile file( ( _directory + "index").c_str() );
  if( ! file.exists() )
    convertFilenames();

  update();
}


InterruptedDownloads* InterruptedDownloads::getInstance()
{
  return _this;
}


void InterruptedDownloads::update()
{
  // read all filenames of interrupted downloads
  std::map<std::string, InterruptedFile> files;

#ifndef SHARP
  _index_mutex.lock();
#endif

  std::ifstream in( ( _directory + "index" ).c_str() );
  
  if( ! in.is_open() )
    {
#ifndef SHARP
      _index_mutex.unlock();
#endif
      return;
    }
  
  std::string s;
  std::string tmps;
  std::vector< std::string > v;
  std::vector< std::string > tmp;

  char buffer[1024];
  while( in.getline( buffer, 1024 ) )
    {
	  s = buffer;
      tmp.push_back(s);
      
      if( s.find( "<tmpname>" ) != std::string::npos && s.find( "</tmpname>" ) != std::string::npos )
		{
		  std::string::size_type idx1 = s.find( "<tmpname>" );
		  std::string::size_type idx2 = s.find( "</tmpname>" );
		  idx1 = s.find_first_not_of( " ", idx1 + 9);
		  
		  tmps = s.substr( idx1, idx2 - idx1 );
		}
	  
      if( s.find("</file>") != std::string::npos )
		{
		  QFile f( ( _directory + tmps ).c_str() );
		  
		  if( f.exists() )
			{
			  InterruptedFile file( _directory + tmps );
			  files.insert( std::make_pair( tmps, file.completeName() ) );
			  
			  for( int i = 0; i < tmp.size(); ++i )
				v.push_back( tmp[i] );
			}
		  
		  tmp.clear();
		  tmps = "";
		}
    }

  in.close();

  std::ofstream out( ( _directory + "index" ).c_str() );
  for( int j = 0; j < v.size(); ++j )
    out << v[j] << std::endl;
  out.close();

#ifndef SHARP
  _index_mutex.unlock();
#endif

  // find all interrupted files in the directory
//   std::map<std::string, InterruptedFile> files;
//   QDir d(_directory.c_str(), "*", QDir::Name|QDir::IgnoreCase, QDir::Files);
//   for(int i = 0; i < d.count(); ++i)
//     {
//       InterruptedFile file(_directory + "/" + std::string(d[i]));
//       if( ! file.isValid() ) continue;

//       files.insert( std::make_pair(file.completeName(), file) );
//     }


  // delete all entries from the listview which do not exist in the directory
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.begin();
  while(pos != _file_map.end())
    {
      if( files.find(pos->second.completeName()) == files.end() ) 
	{
	  deleteItem(pos->first);
	  _file_map.erase(pos++);
	}
      else
	++pos;
    }


  // add all files from the directory which do not exist in the listview
  std::map<std::string, InterruptedFile>::iterator file_pos = files.begin();
  
  while( file_pos != files.end() )
    {
      for( pos = _file_map.begin(); pos != _file_map.end(); ++pos )
	if( pos->second.completeName() == file_pos->second.completeName() ) 
	  {
	    // update progress
	    pos->first->setText(3, pos->second.strprogress().c_str());
	    break;
	  }

      if( pos == _file_map.end() )
	{
	  InterruptedViewItem* item;

	  std::map<InterruptedViewItem*, InterruptedFile>::iterator p;

	  QListViewItem* parent_item = NULL;

	  for( p = _file_map.begin(); p != _file_map.end(); ++p)
	    if( p->second.size() == file_pos->second.size() )
	      {
		parent_item = p->first;
		if( p->first->firstChild() )
		  {
		    parent_item = p->first;
		    break;
		  }
	      }

	  if( parent_item )
	    {
	      item = new InterruptedViewItem( parent_item );
	      _parent->_widget_interrupted->ui_listview_interrupt->setOpen( parent_item, true );
	    }
	  else
	    item = new InterruptedViewItem(_parent->_widget_interrupted->ui_listview_interrupt);

	  
	  item->setText(0, file_pos->second.filename().c_str());
	  item->setText(1, file_pos->second.ext().c_str());
	  item->setText(2, file_pos->second.strsize().c_str());
	  item->setText(3, file_pos->second.strprogress().c_str());
	  item->setText(4, file_pos->second.ip().c_str());
	  
	  _file_map.insert( std::make_pair(item, file_pos->second) );
	}

      ++file_pos;
    }
}

void InterruptedDownloads::getSelectedFiles(std::vector<InterruptedFile>& files)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos;

  for(pos = _file_map.begin(); pos != _file_map.end(); ++pos)
    if(pos->first->isSelected()) files.push_back(pos->second);
}

void InterruptedDownloads::getFiles(std::vector<InterruptedFile>& files, const bool force_update)
{
  if( force_update )
    update();

  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos;
  for(pos = _file_map.begin(); pos != _file_map.end(); ++pos) files.push_back(pos->second);
}

void InterruptedDownloads::deleteSelectedFiles()
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos;

  for(pos = _file_map.begin(); pos != _file_map.end(); )
    if(pos->first->isSelected())
      {
	if( pos->second.getColored() )
	  {
	    std::map<InterruptedViewItem*, QueryHitEntry>::iterator p = _qhe.find(pos->first);
	    
	    if(p != _qhe.end())
	      QtellaSub::getInstance()->download_manager->deleteDownload(p->second);
	  }
	
	if(!QFile::remove(pos->second.completeName().c_str()))
	  {
	    std::string mess = std::string(tr("Could not remove file").latin1());
	    Logging::getInstance()->log(Logging::Error, mess + " [" + pos->second.completeName() + "]");
	  }
	else
	  deleteFromIndex( pos->second.completeName() );

	deleteItem(pos->first);
	_file_map.erase(pos++);
      }
    else ++pos;
}

void InterruptedDownloads::searchSelectedFiles()
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.begin();
  
  while(pos != _file_map.end())
    {
      if( !pos->first->isSelected() ) { ++pos; continue; }

      std::vector<std::string> v;
      StringManipulation sm(pos->second.filename());
      sm.extractWords(v);

      std::vector<std::string> search_words;
      int i;
      for(i = 0; i < v.size(); ++i)
	if(search_words.size() < 3) search_words.push_back(v[i]);
	else
	  {
	    int j = 0;
	    for(int k = 0; k < search_words.size(); ++k)
	      if(search_words[k].size() < search_words[j].size()) j = k;

	    if(search_words[j].size() < v[i].size()) search_words[j] = v[i];
	  }

      std::string search;
      for(i = 0; i < search_words.size(); ++i) search += search_words[i] + " ";
      if(!search.empty()) search = search.substr(0, search.size()-1);

      SearchDialog d(0, 0, true);
      d.setQuery(search);
      if(d.exec() == SearchDialog::Accepted) _parent->search(d.getQuery());

      ++pos;
    }
}

void InterruptedDownloads::resumeSelectedFiles()
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.begin();
  
  while(pos != _file_map.end())
    {
      if( !pos->first->isSelected() ) { ++pos; continue; }

      if( pos->second.getColored() )
	{
	  QMessageBox::information(0, tr("Information"), 
				   tr("An interrupted file can be resumed only one time."), QMessageBox::Ok);
	  ++pos;
	  continue;
	}

      InterruptedFileSearch d(0, 0, true);
      d.init(pos->second.size());
      if(d.exec() == InterruptedFileSearch::Accepted)
	{
	  QueryHitEntry q = *d.getSelectedQueryHit();

	  InterruptedViewItem* item = (InterruptedViewItem*)q.item;
	  q.item = NULL; // do not destroy item when contructor is called

	  _qhe.insert( std::make_pair(pos->first, q) );
	  _parent->download_manager->addDownload(q, item, pos->second.filename(), pos->first);
	}

      ++pos;
    }
}

void InterruptedDownloads::newQueryHit(unsigned long fsize)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos;

  for(pos = _file_map.begin(); pos != _file_map.end(); ++pos)
    if(pos->second.size() == fsize) 
      {
	pos->second.incFound();
	updateBall(pos->first);
      }
}

void InterruptedDownloads::removeQueryHit(unsigned long fsize)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos;

  for(pos = _file_map.begin(); pos != _file_map.end(); ++pos)
    if(pos->second.size() == fsize) 
      {
	pos->second.decFound();
	updateBall(pos->first);
      }
}

void InterruptedDownloads::setYellow(InterruptedViewItem *item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;
  pos->second.setColored();
  item->setPixmap(0, *(Icon::getInstance()->getYellowBall()));
}

void InterruptedDownloads::setRed(InterruptedViewItem *item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;
  pos->second.setColored();
  item->setPixmap(0, *(Icon::getInstance()->getRedBall()));
}

void InterruptedDownloads::setGreen(InterruptedViewItem *item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;
  pos->second.setColored();
  item->setPixmap(0, *(Icon::getInstance()->getGreenBall()));
}

void InterruptedDownloads::setSmile(InterruptedViewItem *item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;
  pos->second.setColored();
  item->setPixmap(0, *(Icon::getInstance()->getSmile()));
}

void InterruptedDownloads::setGreenSmile(InterruptedViewItem *item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;
  pos->second.setColored();
  item->setPixmap(0, *(Icon::getInstance()->getGreenSmile()));
}

void InterruptedDownloads::updateBall(InterruptedViewItem *item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;

  if( pos->second.getFound() > 0 )
    if( pos->second.getColored() == 0 ) item->setPixmap(0, *(Icon::getInstance()->getGreyBall()));

  if( pos->second.getFound() == 0)
    if( pos->second.getColored() == 0) item->setPixmap(0, QPixmap());
}

void InterruptedDownloads::clearColored(InterruptedViewItem* item)
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.find(item);
  if(pos == _file_map.end()) return;
  pos->second.clearColored();
  updateBall(item);
}

void InterruptedDownloads::slotShowContextMenu(InterruptedViewItem* item, const QPoint& p, int i)
{
  _context_menu->popup(p);
}

void InterruptedDownloads::abortSelectedFiles()
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos;

  for(pos = _file_map.begin(); pos != _file_map.end(); ++pos)
    if( (pos->first->isSelected()) && (pos->second.getColored()) )
      {
	std::map<InterruptedViewItem*, QueryHitEntry>::iterator p = _qhe.find(pos->first);
	
	if(p != _qhe.end())
	  QtellaSub::getInstance()->download_manager->abortDownload(p->second);
      }
}

void InterruptedDownloads::convertFilenames()
{
  // first convert all very old file names

  QDir d(_directory.c_str(), "*", QDir::Name|QDir::IgnoreCase, QDir::Files);

  for(int i = 0; i < d.count(); ++i)
    {
      InterruptedFile ifile(_directory + "/" + std::string(d[i].latin1()));
      
      if(!ifile.isValid()) continue;

      std::string n = ifile.completeName();
      std::string::size_type idx = n.find(".part_");

      for(int j = 0; j < 4; ++j) idx = n.find("_", idx + 1);
      idx = n.find_first_not_of("0123456789", idx + 1);

      if( n[idx] != '_' )
	{
	  std::strstream str;
	  str << n.substr(0, idx) << "_0-" << (ifile.size() - 1) << n.substr(idx) << std::ends;
	  
	  QDir dir;
	}
    }

  // now convert old format to the index file
  
#ifndef SHARP
  _index_mutex.lock();
#endif
  std::ofstream index( ( _directory + "/index" ).c_str() );

  if( index.is_open() )
    {
      QDir d(_directory.c_str(), "*", QDir::Name|QDir::IgnoreCase, QDir::Files);
      
      for(int i = 0; i < d.count(); ++i)
	{
	  InterruptedFile ifile(_directory + "/" + std::string(d[i].latin1()));
	  
	  if( ! ifile.isValid() ) continue;
	  
	  index << "<file>" << std::endl
		<< "    <name>" << ifile.filename() << "</name>" << std::endl
		<< "    <tmpname>" << d[i] << "</tmpname>" << std::endl
		<< "    <size>" << ifile.size() << "</size>" << std::endl
		<< "    <start>" << ifile.start() << "</start>" << std::endl
		<< "    <end>" << ifile.end() << "</end>" << std::endl
		<< "    <host>" << ifile.host() << "</host>" << std::endl
		<< "    <index>-1</index>" << std::endl
		<< "</file>" << std::endl;
	}

      index.close();
    }
  else
    {
      QMessageBox::warning(0, tr("Warning"), tr("Cannot create index file"), QMessageBox::Ok, 0);
#ifndef SHARP
      _index_mutex.unlock();
#endif
      return;
    }

#ifndef SHARP
  _index_mutex.unlock();
#endif
}


void InterruptedDownloads::resumeFromHost()
{
  std::map<InterruptedViewItem*, InterruptedFile>::iterator pos = _file_map.begin();

  while(pos != _file_map.end())
    if( pos->first->isSelected() )
      {
	if( pos->second.getColored() )
	  {
	    QMessageBox::information(0, tr("Information"), 
				     tr("An interrupted file can be resumed only one time."), QMessageBox::Ok);
	    ++pos;
	    continue;
	  }

	//cout << pos->second.index() << endl;

	Address     addr( pos->second.host(), pos->second.port() );
	std::string id = "0000000000000000";
	std::string filename = pos->second.filename();

	QueryHitEntry qhe( filename,
			   pos->second.size(),
			   pos->second.index(),
			   0,
			   QueryHitEntry::Ready,
			   addr,
			   id,
			   NULL );

	_parent->download_manager->addDownload(qhe, NULL, "", pos->first );

// 	ResumeHost rh(0, 0, true);
// 	rh.ui_lineedit_ip->setText(pos->second.host().c_str());
  
// 	if( rh.exec() == ResumeHost::Accepted )
// 	  {
// 	    //QueryHitEntry q // geht nicht ??
// 	  }
	++pos;
      }
    else ++pos;

//       InterruptedFileSearch d(0, 0, true);
//       d.init(pos->second.size());
//       if(d.exec() == InterruptedFileSearch::Accepted)
// 	{
// 	  QueryHitEntry q = *d.getSelectedQueryHit();

// 	  InterruptedViewItem* item = q.item;
// 	  q.item = NULL; // do not destroy item when contructor is called

// 	  _qhe.insert( make_pair(pos->first, q) );
// 	  _parent->download_manager->addDownload(q, item, pos->second.filename(), pos->first);
// 	}

//       ++pos;
}


void InterruptedDownloads::deleteItem( InterruptedViewItem* item )
{
  if( item->firstChild() )
    {
      QListViewItem* first = item->firstChild();
      first->moveItem(item);

      QListViewItem* i;
      while( ( i = item->firstChild() ) )
	{
	  item->takeItem(i);
	  first->insertItem(i);
	}
    }

  delete item;
}


const void InterruptedDownloads::addInterruptedDownload( const std::string& filename, const Q_UINT32 index,
							 const Q_UINT16 port )
{
#ifndef SHARP
  _index_mutex.lock();
#endif

  std::ofstream out( ( _directory + "index" ).c_str(), std::ios::app );
  
  if( ! out.is_open() )
    {
      out.open( (_directory + "index").c_str() );

      if( ! out.is_open() )
	{
#ifndef SHARP
	  _index_mutex.unlock();
#endif
	  return;
	}
    }

  InterruptedFile file( filename );
  
  std::string f = filename;
  if( f.find("/") != std::string::npos )
    f.erase( 0, f.find_last_of("/") + 1 );

  out << "<file>" << std::endl
      << "    <name>" << file.filename() << "</name>" << std::endl
      << "    <tmpname>" << f << "</tmpname>" << std::endl
      << "    <size>" << file.size() << "</size>" << std::endl
      << "    <start>" << file.start() << "</start>" << std::endl
      << "    <end>" << file.end() << "</end>" << std::endl
      << "    <host>" << file.host() << "</host>" << std::endl
      << "    <index>" << index << "</index>" << std::endl
      << "    <port>" << port << "</port>" << std::endl
      << "</file>" << std::endl;
  
  out.close();
#ifndef SHARP
  _index_mutex.unlock();
#endif
}


const void InterruptedDownloads::deleteFromIndex( const std::string& filename )
{
#ifndef SHARP
  _index_mutex.lock();
#endif

  std::string f = filename;
  if( f.find("/") != std::string::npos )
    f.erase( 0, f.find_last_of("/") + 1 );

  std::vector< std::string > v;
  std::vector< std::string > o;

  std::ifstream in( ( _directory + "index" ).c_str() );
  
  if( ! in.is_open() )
    {
#ifndef SHARP
      _index_mutex.unlock();
#endif
      return;
    }

  std::string s;
  std::string current_tmpname;
  char buffer[1024];

  while( in.getline( buffer, 1024 ) )
    {
	  s = buffer;
      v.push_back( s );

      if( s.find("<tmpname>") != std::string::npos )
		{
		  std::string::size_type idx1 = s.find("<tmpname>");
		  std::string::size_type idx2 = s.find("</tmpname>");
		  idx1 = s.find_first_not_of( " ", idx1 + 9 );
		  current_tmpname = s.substr( idx1, idx2 - idx1 );
		}
	  
      if( s.find("</file>") != std::string::npos )
		{
		  if( current_tmpname != f )
			for( int i = 0; i < v.size(); ++i )
			  o.push_back( v[i] );
		  
		  current_tmpname = "";
		  v.clear();
		}
    }
  
  std::ofstream out( ( _directory + "index" ).c_str() );

  if( out.is_open() )
    for( int j = 0; j < o.size(); ++j )
      out << o[j] << std::endl;

  in.close();
  out.close();

#ifndef SHARP
  _index_mutex.unlock();
#endif
}



const void InterruptedDownloads::getFileInformation( const std::string& filename, 
						     std::map< std::string, std::string >& dst)
{
#ifndef SHARP
  _index_mutex.lock();
#endif

  std::string f = filename;
  if( f.find("/") != std::string::npos )
    f.erase( 0, f.find_last_of("/") + 1 );

  std::vector< std::string > v;

  std::ifstream in( ( _directory + "index" ).c_str() );
  
  if( ! in.is_open() )
    {
#ifndef SHARP
      _index_mutex.unlock();
#endif
      return;
    }

  std::string s;
  std::string current_tmpname;
  char buffer[1024];

  while( in.getline( buffer, 1024 ) )
    {
	  s = buffer;
      v.push_back( s );
	  
      if( s.find("<tmpname>") != std::string::npos )
		{
		  std::string::size_type idx1 = s.find("<tmpname>");
		  std::string::size_type idx2 = s.find("</tmpname>");
		  idx1 = s.find_first_not_of( " ", idx1 + 9 );
		  current_tmpname = s.substr( idx1, idx2 - idx1 );
		}
	  
      if( s.find("</file>") != std::string::npos )
		{
		  if( current_tmpname == f )
			{
			  for( int i = 1; i < v.size(); ++i )
				{
				  std::string::size_type idx1 = v[i].find("<");
				  if( idx1 == std::string::npos )
					continue;
				  std::string::size_type idx2 = v[i].find(">", idx1);
				  if( idx2 == std::string::npos )
					continue;
				  
				  std::string key = v[i].substr( idx1 + 1, idx2 - idx1 - 1 );
				  
				  std::string::size_type idx3 = v[i].find( "</" + key + ">" );
				  if( idx3 == std::string::npos )
					continue;
				  
				  idx1 = v[i].find_first_not_of(" ", idx2 + 1);
				  
				  dst[key] = v[i].substr( idx1, idx3 - idx1 );
				}
			  break;
			}
		  current_tmpname = "";
		  v.clear();
		}
    }

  in.close();

#ifndef SHARP
  _index_mutex.unlock();
#endif
}
