#include "InterruptedFile.h"
#include "StringManipulation.h"
#include "QtellaSub.h"
#include "InterruptedDownloads.h"
#include <qfile.h>
#include <strstream>
#include <iostream>
#include <iomanip>

InterruptedFile::InterruptedFile(std::string file) : _filename(file), _found(0), _colored(0)
{
}

const std::string InterruptedFile::filename()
{
  std::string::size_type idx = _filename.find_last_of("/");
  std::string file;

  if(idx != std::string::npos)
    file = _filename.substr(idx+1);
  else
    file = _filename;

  if( (idx = file.find(".part_")) == std::string::npos ) return file;

  std::string::size_type idx2 = file.find_last_of(".");
  file.erase(idx, idx2-idx);
  return file;
}

const std::string InterruptedFile::ext()
{
  std::string::size_type idx = _filename.find_last_of(".");

  if(idx != std::string::npos)
    return _filename.substr(idx+1);
  else
    return _filename;
}

const std::string InterruptedFile::host()
{
  std::string::size_type idx = _filename.find(".part_");

  if( idx == std::string::npos ) return "";

  idx = _filename.find("_", idx + 6);
  idx = _filename.find("_", idx + 1);

  if( idx == std::string::npos ) return "";

  return _filename.substr( idx + 1, _filename.find("_", idx + 1) - idx - 1 );
}

const std::string InterruptedFile::strsize(bool comma)
{
  std::string::size_type idx = _filename.find(".part_");

  if(idx == std::string::npos) return "";

  idx = _filename.find("_", idx+6);
  std::string::size_type idx2 = _filename.find("_", idx+1);

  if(comma)
    return StringManipulation::insertDelimiter(_filename.substr(idx+1, idx2-idx-1), ',', 3);
  else
    return _filename.substr(idx+1, idx2-idx2-1);
}

const unsigned long InterruptedFile::size()
{
  std::string s = strsize(false);
  std::strstream str;
  str << s << std::ends;
  unsigned long size;
  str >> size;
  return size;
}

const unsigned long InterruptedFile::read()
{
  QFile f(_filename.c_str());
  return f.size();
}

const unsigned long InterruptedFile::toread()
{
  unsigned long size;
  std::strstream str;
  str << strsize() << std::ends;
  str >> size;
  return (size - read());
}

const double InterruptedFile::progress()
{
  if(size() > 0)
    return
      static_cast<double>(100) * static_cast<double>(read()) / static_cast<double>(size());
  else
    return 0;
}

const std::string InterruptedFile::strprogress(int precision)
{
  std::strstream str;
  str.setf(std::ios::fixed);
  str << std::setprecision(precision) << progress() << "%" << std::ends;
  std::string s(str.str());
  return s;
}

const::std::string InterruptedFile::ip()
{
  std::string::size_type idx = _filename.find(".part_");

  if(idx == std::string::npos) return "";

  idx = _filename.find("_", idx+6);
  idx = _filename.find("_", idx+1);
  std::string::size_type idx2 = _filename.find("_", idx+1);

  return _filename.substr(idx+1, idx2-idx-1);
}

const bool InterruptedFile::isValid()
{
  return (_filename.find(".part_") != std::string::npos);
}


const unsigned long InterruptedFile::start()
{
  std::string::size_type idx = _filename.find(".part_");

  if(idx == std::string::npos) return 0;

  idx = _filename.find("_", idx+6);
  for(int i = 0; i < 3; ++i)
    idx = _filename.find("_", idx+1);

  std::string::size_type idx2 = _filename.find("-", idx+1);

  std::strstream str;
  str << _filename.substr(idx+1, idx2-idx-1) << std::ends;
  unsigned long ret;
  str >> ret;

  return ret;
}


const unsigned long InterruptedFile::end()
{
  std::string::size_type idx = _filename.find(".part_");

  if(idx == std::string::npos) return 0;

  idx = _filename.find("-", idx + 6);
  std::string::size_type idx2 = _filename.find_first_not_of("0123456789", idx + 1);

  std::strstream str;
  str << _filename.substr(idx+1, idx2-idx-1) << std::ends;
  unsigned long ret;
  str >> ret;

  return ret;
}


const std::string InterruptedFile::id()
{
  return id(_filename);
}


const std::string InterruptedFile::id(std::string filename)
{
  std::string ret;

  std::string::size_type idx = filename.find(".part_");
  if(idx == std::string::npos) return "";

  idx += 6;
  std::string::size_type idx2 = filename.find("_", idx);
  std::string stime = filename.substr(idx, idx2 - idx);

  idx = filename.find("_", idx2 + 1);
  idx = filename.find("_", idx + 1);
  idx += 1;
  idx2 = filename.find("_", idx);
  std::string id = filename.substr(idx, idx2 - idx);

  ret = stime + "-" + id;
  return ret;
}


const void InterruptedFile::split(const std::string s, time_t& t, unsigned& id)
{
  std::strstream str;
  str << s.substr(0, s.find("-")) << std::ends;
  str >> t;

  std::strstream str_id;
  str_id << s.substr(s.find("-") + 1) << std::ends;
  str >> id;
}


const std::string InterruptedFile::completeName()
{
  return _filename;
}


const void InterruptedFile::incFound()
{
  ++_found;
}


const void InterruptedFile::decFound()
{
  --_found;
}

const void InterruptedFile::setColored()
{
  _colored = 1;
}

const void InterruptedFile::clearColored()
{
  _colored = 0;
}

const int InterruptedFile::getColored()
{
  return _colored;
}

const int InterruptedFile::getFound()
{
  return _found;
}

const int InterruptedFile::index()
{
  std::map< std::string, std::string > m;
  QtellaSub::getInstance()->_interrupted_downloads->getFileInformation( _filename, m );

  std::strstream str;
  str << m["index"] << std::ends;
  
  int i;
  str >> i;

  return i;
}


const Q_UINT16 InterruptedFile::port()
{
  std::map< std::string, std::string > m;
  QtellaSub::getInstance()->_interrupted_downloads->getFileInformation( _filename, m );

  std::strstream str;
  str << m["port"] << std::ends;
  
  Q_UINT16 i;
  str >> i;

  return i;
}
